% Generated by roxygen2 (4.1.1.9000): do not edit by hand
% Please edit documentation in R/rwirelesscom.R
\name{f8pskmod}
\alias{f8pskmod}
\title{8-PSK Modulator}
\usage{
f8pskmod(bits)
}
\arguments{
\item{bits}{- vector of bits (0's and 1's).}
}
\value{
returns a complex vector of length = (length(bits) mod 3), 8-PSK symbols
}
\description{
Receives a vector of bits (1's and 0's). The received vector is mapped
to in-phase (real) and quadrature (imaginary) components, according to
a Binary Reflective Gray Code (BRGC, see reference). Each received pair of bits
are are mapped to 8-PSK symbols,
with \eqn{sqrt(E_{s})}{sqrt(Es)} (symbol energy) = 1.The bit to symbol mapping is illustrated in the following constellation diagram.
\tabular{cc}{
input \tab output \cr
000 \tab \eqn{  0 }  \cr
001 \tab \eqn{  \pi/4 } \cr
011 \tab \eqn{  \pi/2} \cr
010 \tab \eqn{  3 \pi/4} \cr
110 \tab  \eqn{ pi} \cr
111 \tab  \eqn{ -3 \pi/4} \cr
101 \tab  \eqn{ - \pi/2} \cr
100 \tab  \eqn{ - \pi/4} \cr
}
Reference: E. Agrell, J Lassing, E. Strom, and T. Ottosson, Gray Coding for Multilevel Constellations In Gaussian Noise, IEEE Transactions on Communications, Vol. 53, No. 1, January 2007
}
\examples{
M=8
Nsymbols=10
Nbits=log2(M)*Nsymbols
bits <- sample(0:1,Nbits, replace=TRUE)
s <- f8pskmod(bits)
}
\seealso{
Other modulation.demodulation.communications: \code{\link{f16pskdemod}};
  \code{\link{f16pskmod}}; \code{\link{f16qamdemod}};
  \code{\link{f16qammod}}; \code{\link{f64qamdemod}};
  \code{\link{f64qammod}}; \code{\link{f8pskdemod}};
  \code{\link{fNo}}; \code{\link{fbpskdemod}};
  \code{\link{fbpskmod}}; \code{\link{fqpskdemod}};
  \code{\link{fqpskmod}}; \code{\link{iqdensityplot}};
  \code{\link{iqscatterplot}}
}

