#' Get authors
#' 
#' Get author names from the an R package DESCRIPTION file.
#' @param add_html Add HTML styling to certain fields (e.g "authors").
#' @inheritParams desc::desc_fields
#' @returns Authors as a raw text or HTML string.
#' 
#' @keywords internal
#' @importFrom desc desc_fields desc_get_field
get_authors <- function(add_html=FALSE,
                        file = "."){
  
  fields <- desc::desc_fields(file=file)
  author_fields <- grep("Authors*",fields,value = TRUE)
  if(length(author_fields)>0){
   authors <- desc::desc_get_field(author_fields[[1]])  
   auths <- eval(parse(text = gsub('person','c',authors)));
   authors <- paste(auths[names(auths)=='given'],
                    auths[names(auths)=='family'], collapse = ', ')
   if(isTRUE(add_html)){
     return(paste0("<h4>Authors: <i>",authors,"</i></h4>"))
   } else {
     return(authors)
   }
  } else {
    return(NULL)
  } 
}