\name{countriesCoarseLessIslands}
\alias{countriesCoarseLessIslands}
\docType{data}
\title{ a coarse resolution world map, a vector map of 177 country boundaries, suitable for global maps }
\description{
A 'SpatialPolygonsDataFrame' [package "sp"] object containing a simplified world map. 
Polygons are attributed with country codes.
177 countries. Based on Natural Earth data.
}
\usage{data(countriesCoarseLessIslands)}
\format{
  The format is:
Formal class 'SpatialPolygonsDataFrame' [package "sp"] with 5 slots
  ..@ data       :'data.frame':	178 obs. of  51 variables:
  .. ..$ ISO3              : Factor w/ 174 levels "-99","AFG","AGO",..: 1 1 1 1 2 3 4 5 6 7 ...
  .. ..$ ScaleRank         : int [1:178] 1 1 1 1 1 1 1 1 1 1 ...
  .. ..$ LabelRank         : int [1:178] 1 1 1 1 1 1 1 1 1 1 ...
  .. ..$ FeatureCla        : Factor w/ 1 level "Admin-0 countries": 1 1 1 1 1 1 1 1 1 1 ...
  .. ..$ SOVEREIGNT        : Factor w/ 172 levels "Afghanistan",..: 169 80 112 137 1 4 2 160 6 7 ...
  .. ..$ SOV_A3            : Factor w/ 172 levels "AFG","AGO","ALB",..: 133 86 38 141 1 2 3 4 5 6 ...
  .. ..$ ADM0_DIF          : num [1:178] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ LEVEL             : num [1:178] 2 2 2 2 2 2 2 2 2 2 ...
  .. ..$ TYPE              : Factor w/ 6 levels "Country","County",..: 4 6 6 4 6 6 6 6 6 6 ...
  .. ..$ ADMIN             : Factor w/ 177 levels "Afghanistan",..: 174 83 116 141 1 4 2 164 6 7 ...
  .. ..$ ADM0_A3           : Factor w/ 177 levels "AFG","AGO","ALB",..: 137 89 39 145 1 2 3 4 5 6 ...
  .. ..$ GEOU_DIF          : num [1:178] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ GEOUNIT           : Factor w/ 177 levels "Afghanistan",..: 174 83 116 141 1 4 2 165 6 7 ...
  .. ..$ GU_A3             : Factor w/ 177 levels "AFG","AGO","ALB",..: 137 89 39 145 1 2 3 4 5 6 ...
  .. ..$ SU_DIF            : num [1:178] 0 0 0 0 0 0 0 0 0 0 ...
  .. ..$ SUBUNIT           : Factor w/ 177 levels "Afghanistan",..: 174 83 116 141 1 4 2 165 6 7 ...
  .. ..$ SU_A3             : Factor w/ 177 levels "AFG","AGO","ALB",..: 137 89 39 145 1 2 3 4 5 6 ...
  .. ..$ NAME              : Factor w/ 177 levels "Afghanistan",..: 173 85 109 144 1 4 2 165 6 7 ...
  .. ..$ ABBREV            : Factor w/ 177 levels "Afg.","Alb.",..: 173 85 108 143 1 4 2 163 6 7 ...
  .. ..$ POSTAL            : Factor w/ 172 levels "A","AE","AF",..: 168 82 33 138 3 5 4 2 7 8 ...
  .. ..$ NAME_FORMA        : Factor w/ 151 levels "Arab Republic of Egypt",..: NA NA NA 114 30 55 54 NA 2 56 ...
  .. ..$ TERR_             : Factor w/ 6 levels "Commonwealth of U.S.A.",..: 3 NA NA NA NA NA NA NA NA NA ...
  .. ..$ NAME_SORT         : Factor w/ 177 levels "Afghanistan",..: 174 88 40 143 1 4 2 165 6 7 ...
  .. ..$ MAP_COLOR         : num [1:178] 4 11 8 2 7 1 6 3 13 10 ...
  .. ..$ POP_EST           : num [1:178] -99 1804838 265100 3500000 28400000 ...
  .. ..$ GDP_MD_EST        : num [1:178] 900 5352 3600 -99 22270 ...
  .. ..$ FIPS_10_          : num [1:178] -99 0 -99 -99 0 0 0 0 0 0 ...
  .. ..$ ISO_A2            : Factor w/ 174 levels "-99","AE","AF",..: 1 1 1 1 3 6 4 2 8 5 ...
  .. ..$ ISO_A3            : Factor w/ 174 levels "-99","AFG","AGO",..: 1 1 1 1 2 3 4 5 6 7 ...
  .. ..$ ISO_N3            : num [1:178] -99 -99 -99 -99 4 24 8 784 32 51 ...
  .. ..$ ISO2              : Factor w/ 222 levels "AD","AE","AF",..: NA NA NA NA 3 9 6 2 10 7 ...
  .. ..$ Name              : Factor w/ 232 levels "Afghanistan",..: NA NA NA NA 1 6 2 215 9 10 ...
  .. ..$ FIPS              : Factor w/ 222 levels "AA","AC","AE",..: NA NA NA NA 4 10 7 3 12 8 ...
  .. ..$ Numeric           : num [1:178] NA NA NA NA 4 24 8 784 32 51 ...
  .. ..$ GEO3major         : Factor w/ 7 levels "7","Africa","Asia and the Pacific",..: NA NA NA NA 3 2 4 7 5 4 ...
  .. ..$ GEO3              : Factor w/ 23 levels "Arabian Peninsula",..: NA NA NA NA 16 19 7 1 15 9 ...
  .. ..$ IMAGE24           : Factor w/ 25 levels "Asia-Stan","Brazil",..: NA NA NA NA 8 20 4 13 17 18 ...
  .. ..$ GLOCAF            : Factor w/ 19 levels "Brazil","Canada",..: NA NA NA NA 14 17 4 9 13 5 ...
  .. ..$ Stern             : Factor w/ 13 levels "Australasia",..: NA NA NA NA 4 11 6 13 9 6 ...
  .. ..$ SRESmajor         : Factor w/ 4 levels "ALM","ASIA","OECD90",..: NA NA NA NA 2 1 4 1 1 4 ...
  .. ..$ SRES              : Factor w/ 11 levels "Central and Eastern Europe (EEU)",..: NA NA NA NA 9 10 1 4 3 5 ...
  .. ..$ GBD               : Factor w/ 21 levels "Asia Pacific, High Income",..: NA NA NA NA 4 18 8 15 13 2 ...
  .. ..$ AVOIDnumeric      : num [1:178] NA NA NA NA 21 24 25 30 26 25 ...
  .. ..$ AVOIDname         : Factor w/ 30 levels "Australia","Brazil",..: NA NA NA NA 19 27 7 15 25 7 ...
  .. ..$ Vulnerability.Name: Factor w/ 234 levels "Afghanistan",..: NA NA NA NA 1 6 2 220 9 10 ...
  .. ..$ GIS.Country       : Factor w/ 234 levels "Afghanistan",..: NA NA NA NA 1 6 2 219 9 10 ...
  .. ..$ CNTRY_NAME        : Factor w/ 233 levels "Afghanistan",..: NA NA NA NA 1 6 2 218 9 10 ...
  .. ..$ GMI_CNTRY         : Factor w/ 225 levels "ABW","AFG","AGO",..: NA NA NA NA 2 3 5 8 9 10 ...
  .. ..$ LDC               : Factor w/ 2 levels "LDC","other": NA NA NA NA 1 1 2 2 2 2 ...
  .. ..$ SID               : Factor w/ 2 levels "other","SID": NA NA NA NA 1 1 1 1 1 1 ...
  .. ..$ LLDC              : Factor w/ 2 levels "LLDC","other": NA NA NA NA 1 2 2 2 2 1 ...
  ..@ polygons   :List of 177

}
\details{
Derived fron version 1.4.0 of Natural Earth data 1:110 m data.    

The different country boundaries in rworldmap are processed from Natural Earth Data as follows :
All :         
~ rename any non-ASCII country names that cause R trouble
~ rename Curacao which is particularly troublesome !
~ check polygon geometries using checkPolygonsHoles 
~ set projections, e.g. proj4string(countriesCoarse) <- CRS("+proj=longlat +ellps=WGS84 +datum=WGS84 +no_defs")
~ set polygon IDs to country names (from ADMIN field)
~ copy ISO_A3 to ISO3
~ replace missing ISO3 codes (6 in this version) with ADM0_A3
~ check for duplicate ISO3 codes (2 in this version)
~ set ISO3 for Gaza to Gaza and 'Ashmore and Cartier Islands' to Ashm
~ replace POP_EST of -99 with NA
~ join on countryRegions data

countriesCoarseLessIslands :  ne_110
countriesCoarse : ne_110 plus extra countries from ne_50 plus Tuvalu from ne_10
countriesLow :    ne_50 plus Tuvalu from ne_10
countriesHigh (in package rworldxtra) :   ne_10
  
}
\source{
http://www.naturalearthdata.com/downloads/110m-cultural-vectors/110m-admin-0-countries/
}
\examples{
data(countriesCoarseLessIslands)
}
\keyword{datasets}
