% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load.multi.R
\name{load.multi}
\alias{load.multi}
\title{Load all matching files from a directory into a list of rwty.trees objects}
\usage{
load.multi(path = ".", format = "mb", labels = NA, ...)
}
\arguments{
\item{path}{The path to the directory containing tree and log files}

\item{format}{File format, which is used to find tree and log files.
Currently accepted values are "mb" for MrBayes, "beast" for BEAST, and "*beast" for *BEAST.
If you would like RWTY to understand additional formats, please contact the authors and send us some sample data.}

\item{labels}{A vector of names to assign to chains as they are read in.}

\item{...}{Further arguments to be passed to load.trees.}
}
\value{
output A list of rwty.trees objects containing the multiPhylos and the tables of values from the log files if available.
}
\description{
Finds trees and log files based on format definition, returns rwty.trees objects containing both
}
\examples{
#load.multi(path = "~/my trees/", format = "*beast")
}
\keyword{MCMC,}
\keyword{Phylogenetics,}
\keyword{load,}
\keyword{trees}

