% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webcam.R
\name{webcam}
\alias{webcam}
\title{Returns locations of personal weather stations along with URLs for
their webcam images}
\usage{
webcam(location, key = get_api_key(), raw = FALSE, message = TRUE)
}
\arguments{
\item{location}{location set by set_location}

\item{key}{weather underground API key}

\item{raw}{if TRUE return raw httr object}

\item{message}{if TRUE print out requested URL}
}
\value{
tbl_df of weather stations including:
		   handle, id, city, state, country, tz, lat,
		   lon, last updated, image URL and cam URL.
}
\description{
Returns locations of personal weather stations along with URLs for
their webcam images
}
\examples{
\dontrun{
webcam(set_location(territory = "Hawaii", city = "Honolulu"))
webcam(set_location(territory = "Iowa", city = "Iowa City"))
webcam(set_location(territory = "Iraq", city = "Baghdad"))
}
}
