% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rxrandom.R
\name{rxbinom}
\alias{rxbinom}
\title{Simulate Binomial variable from threefry generator}
\usage{
rxbinom(size, prob, n = 1L, ncores = 1L)
}
\arguments{
\item{size}{number of trials (zero or more).}

\item{prob}{probability of success on each trial.}

\item{n}{number of observations. If \code{length(n) > 1}, the length
    is taken to be the number required.}

\item{ncores}{Number of cores for the simulation

\code{rxnorm} simulates using the threefry sitmo generator.

\code{rxnormV} used to simulate with the vandercorput simulator, but
since it didn't satisfy the normal properties it was changed to simple be
an alias of \code{rxnorm}. It is no longer supported in \code{rxode2({})} blocks}
}
\value{
binomial random deviates
}
\description{
Care should be taken with this method not to encounter the
birthday problem, described
\url{https://www.johndcook.com/blog/2016/01/29/random-number-generator-seed-mistakes/}.
Since the \code{sitmo} \code{threefry}, this currently generates
one random deviate from the uniform distribution to seed the
engine \code{threefry} and then run the code.
}
\details{
Therefore, a simple call to the random number generated followed by a second
call to random number generated may have identical seeds.  As the number of
random number generator calls are increased the probability that the
birthday problem will increase.

The key to avoid this problem is to either run all simulations in the
\code{rxode2} environment once (therefore one seed or series of seeds
for the whole simulation), pre-generate all random variables
used for the simulation, or seed the rxode2 engine with \code{rxSetSeed()}

Internally each ID is seeded with a unique number so that the
results do not depend on the number of cores used.
}
\examples{
\donttest{
## Use threefry engine

rxbinom(10, 0.9, n = 10) # with rxbinom you have to explicitly state n
rxbinom(3, 0.5, n = 10, ncores = 2) # You can parallelize the simulation using openMP

rxbinom(4, 0.7)


## This example uses `rxbinom` directly in the model

rx <- rxode2({
  a <- rxbinom(1, 0.5)
})

et <- et(1, id = 1:2)

s <- rxSolve(rx, et)
}

}
