% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictCount.R
\name{predictCount}
\alias{predictCount}
\title{Predicted Counts for a Generalized Linear Model}
\usage{
predictCount(object, newdata, cilevel = 0.95, digit = 3, print.out = TRUE,
  ...)
}
\arguments{
\item{object}{a \code{glm} object, i.e. the output from \code{\link{glm}}.}

\item{newdata}{prediction data frame.}

\item{cilevel}{confidence level of the interval.}

\item{digit}{decimal numbers after the point.}

\item{print.out}{if \code{TRUE}, print out the prediction matrix.}

\item{\dots}{optional arguments that are passed to the generic \code{predict}.}
}
\value{
A data frame with three columns: \describe{ \item{Predicted}{the
predicted count.} \item{Conf.lower}{the lower bound of the predicted count.}
\item{Conf.upper}{the upper bound of the predicted count.} }
}
\description{
Uses the main output and some error messages from R function 'predict' but
gives you more output. (Error messages are not reliable when used in Splus.)
}
\details{
Note: The data frame, newdata, must have the same column order and data
types (e.g. numeric or factor) as those used in fitting the model.
}
\seealso{
\code{\link{predict}}, \code{\link{predict.glm}}, \code{\link{as.data.frame}}.
}
\keyword{htest}
