% This is a template R document file
% Distributed under GPL 3 or later

\name{AUC}
\alias{AUC}
\title{Area Under Curve}
\description{Compute the area under curve of estimated ROC curve.}
\usage{
 AUC(ROC, method="Simpson", ngrid=256)
}
\arguments{
\item{ROC}{a ``ROC'' object generated by kROC(...).}
\item{method}{a character string giving the numerical integration method to be used. This must be either ``Simpson'' or ``Trapez''.}
\item{ngrid}{the number of grids for numerical integration.}
}
\details{
Compute the area under curve of estimated ROC curve.
}
\value{
An object of class ``AUC''.
}
\author{
  X.F. Wang \email{wangx6@ccf.org}
}
\seealso{
 \code{\link{kROC}}.
}
\examples{

set.seed(100)
n <- 200
x <- rlnorm(n, mean=2, sd=1)
y <- rnorm(n,mean=2,sd=2)

xy.ROC <- kROC(c(x,NA,NA),c(y,1.2, NA), na.rm=TRUE)
plot(xy.ROC)
AUC(xy.ROC)
	
}
\keyword{smoothing}

