% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nonsample.R
\name{nonsample}
\alias{nonsample}
\title{data nonsample}
\format{
A data frame with 100 observations on the following 4 variables.
\describe{
 \item{y}{Direct estimator for each domain.}
 \item{x.hat}{Auxiliary variable for each domain.}
 \item{vardir}{Sampling variances for each domain.}
 \item{var.x}{MSE of auxiliary variable and sorted as \code{x.hat}}
}
}
\usage{
data(nonsample)
}
\description{
This data similar to dataME but have 9 non-sampled area. Generated by following these steps:
\enumerate{
  \item Generate \eqn{x_{i}}{xi} from a UNIF(5, 10) distribution, \eqn{\psi_{i}}{\psii} = 3, \eqn{c_{i}}{ci} = 0.25, and \eqn{\sigma_{v}^{2}}{\sigma2v} = 2.
  \item Generate \eqn{u_{i}}{ui} from a N(0, \eqn{c_{i}}{ci}) distribution, \eqn{e_{i}}{ei} from a N(0, \eqn{\psi_{i}}{\psii}) distribution, and \eqn{v_{i}}{vi} from a N(0, \eqn{\sigma_{v}^{2}}{\sigma2v}) distribution.
  \item Generate \eqn{\hat{x}_{i}}{x.hati} = \eqn{x_{i}}{xi} + \eqn{u_{i}}{ui}.
  \item Then for each iteration, we generated \eqn{Y_{i}}{Yi} = \eqn{2 + 0.5 \hat{x}_{i} + v_{i}}{2 + 0.5*x.hati + vi} and \eqn{y_{i}}{yi} = \eqn{Y_{i} + e_{i}}{Yi + ei}.
}
Direct estimator \code{y}, auxiliary variable \eqn{\hat{x}}{x.hat}, sampling variance \eqn{\psi}{\psi}, and  \eqn{c}{c} are arranged in a dataframe called dataME.
}
