% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/func_estimParam.R
\name{saemixpredict.newdata}
\alias{saemixpredict.newdata}
\alias{estimateMeanParameters.newdata}
\alias{estimateIndividualParameters.newdata}
\title{Predictions for a new dataset}
\usage{
saemixpredict.newdata(
  saemixObject,
  saemix.newdata,
  type = c("ipred", "ypred", "ppred", "icpred"),
  nsamp = 1
)
}
\arguments{
\item{saemixObject}{an SaemixObject from a fitted run}

\item{saemix.newdata}{a dataframe containing the new data. The dataframe must contain the same information as the original dataset (colunm names, etc...)}

\item{type}{one or several of "ipred" (individual predictions using the MAP estimates), "ypred" (population predictions obtained using the population parameters f(E(theta))), "ppred" (mean of the population predictions (E(f(theta)))), "icpred"  (individual predictions using the conditional mean estimates)}

\item{nsamp}{an integer, ignored for other types than icpred; if icpred, returns both the mean of the conditional distribution and nsamp samples, with the corresponding predictions. Defaults to 1.}
}
\value{
a list with two components
}
\description{
Predictions for a new dataset
}
\details{
The function uses estimateMeanParameters.newdata() to set the population estimates for the individual parameters
taking into account the individual covariates and doses,
and estimateIndividualParameters.newdata() to derive individual estimates by computing 
the mean of the conditional distributions (type="icpred") or the MAP estimate (type="ipred")

Warning: this function is currently under development and the output may change in future versions of the package to conform to the usual predict functions.
}
\examples{
# TODO
}
