% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{save_object}
\alias{save_object}
\title{Save an object to a connection(or a file)}
\usage{
save_object(object, key = "pass", pkey = NULL, ascii = FALSE, conn)
}
\arguments{
\item{object}{A R object to be encrypted}

\item{key}{For symmetric encryption, 'pkey' should be NULL (default) and
'key' can be either a string (Default is 'pass') or a raw object. For
asymmetric encryption, both 'key' (private key of the encrypter) and 'pkey'
(public key of the decrypter) should be raw objects.}

\item{pkey}{See 'key'}

\item{ascii}{TRUE, if the encrypted output is a string(written to the text
connection). FALSE, if the encrypted output is a raw object(written to the
raw connection)}

\item{conn}{A connection or a file where the encrypted content is written. If
\code{ascii} is TRUE, an encrypted text is written to the connection. Else,
when \code{ascii} is FALSE(default), a raw object is written to the
connection}
}
\value{
An invisible TRUE
}
\description{
\code{save_object} encrypts a R object to raw or text connection
  or a file. \code{retrieve_object} decrypts a raw or a text connection or a
  file (encrypted by \code{save_object}). Note that \code{retrieve_object}
  returns the object.
}
\examples{
# symmetric case:
all(
  save_object(iris, conn = "iris_safer.bin")
  , identical(retrieve_object(conn = "iris_safer.bin"), iris)
  , unlink("iris_safer.bin") == 0
)

all(
  save_object(iris, conn = "iris_safer_2.txt", ascii = TRUE)
  , identical(retrieve_object(conn = "iris_safer_2.txt", ascii = TRUE), iris)
  , unlink("iris_safer_2.txt") == 0
)

# asymmetric case:
alice <- keypair()
bob   <- keypair()
all(
  save_object(iris, alice$private_key, bob$public_key, conn = "iris_safer.bin")
  , identical(retrieve_object(conn = "iris_safer.bin", bob$private_key, alice$public_key), iris)
  , unlink("iris_safer.bin") == 0
)

}
