% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dual-math.r
\name{MathFun}
\alias{MathFun}
\alias{exp.dual}
\alias{expm1.dual}
\alias{logNeper}
\alias{log.dual}
\alias{log10.dual}
\alias{log2.dual}
\alias{log1p.dual}
\alias{sqrt.dual}
\alias{cos.dual}
\alias{sin.dual}
\alias{tan.dual}
\alias{cospi.dual}
\alias{sinpi.dual}
\alias{tanpi.dual}
\alias{acos.dual}
\alias{asin.dual}
\alias{atan.dual}
\alias{atan2,dual,dual-method}
\alias{atan2,dual,numericOrArray-method}
\alias{atan2,numericOrArray,dual-method}
\alias{cosh.dual}
\alias{sinh.dual}
\alias{tanh.dual}
\alias{acosh.dual}
\alias{asinh.dual}
\alias{atanh.dual}
\alias{abs.dual}
\alias{sign.dual}
\alias{ceiling.dual}
\alias{floor.dual}
\alias{trunc.dual}
\alias{gamma.dual}
\alias{lgamma.dual}
\alias{digamma.dual}
\alias{trigamma.dual}
\alias{psigamma.dual}
\alias{psigamma,dual-method}
\alias{beta,dual,dual-method}
\alias{beta,dual,numericOrArray-method}
\alias{beta,numericOrArray,dual-method}
\alias{lbeta,dual,dual-method}
\alias{lbeta,dual,numericOrArray-method}
\alias{lbeta,numericOrArray,dual-method}
\alias{factorial.dual}
\alias{lfactorial.dual}
\alias{choose,dual,numeric-method}
\alias{lchoose,dual,numeric-method}
\title{Mathematical functions}
\usage{
\method{exp}{dual}(x)

\method{expm1}{dual}(x)

logNeper(x)

\method{log}{dual}(x, base = exp(1))

\method{log10}{dual}(x)

\method{log2}{dual}(x)

\method{log1p}{dual}(x)

\method{sqrt}{dual}(x)

\method{cos}{dual}(x)

\method{sin}{dual}(x)

\method{tan}{dual}(x)

\method{cospi}{dual}(x)

\method{sinpi}{dual}(x)

\method{tanpi}{dual}(x)

\method{acos}{dual}(x)

\method{asin}{dual}(x)

\method{atan}{dual}(x)

\S4method{atan2}{dual,dual}(y, x)

\S4method{atan2}{dual,numericOrArray}(y, x)

\S4method{atan2}{numericOrArray,dual}(y, x)

\method{cosh}{dual}(x)

\method{sinh}{dual}(x)

\method{tanh}{dual}(x)

\method{acosh}{dual}(x)

\method{asinh}{dual}(x)

\method{atanh}{dual}(x)

\method{abs}{dual}(x)

\method{sign}{dual}(x)

\method{ceiling}{dual}(x)

\method{floor}{dual}(x)

\method{trunc}{dual}(x, ...)

\method{gamma}{dual}(x)

\method{lgamma}{dual}(x)

\method{digamma}{dual}(x)

\method{trigamma}{dual}(x)

psigamma.dual(x, deriv = 0)

\S4method{psigamma}{dual}(x, deriv = 0)

\S4method{beta}{dual,dual}(a, b)

\S4method{beta}{dual,numericOrArray}(a, b)

\S4method{beta}{numericOrArray,dual}(a, b)

\S4method{lbeta}{dual,dual}(a, b)

\S4method{lbeta}{dual,numericOrArray}(a, b)

\S4method{lbeta}{numericOrArray,dual}(a, b)

factorial.dual(x)

lfactorial.dual(x)

\S4method{choose}{dual,numeric}(n, k)

\S4method{lchoose}{dual,numeric}(n, k)
}
\arguments{
\item{x}{function argument (dual or numeric object)}

\item{base}{base to which log is computed}

\item{y}{first argument of atan2 function (dual or numeric)}

\item{...}{extra arguments to trunc (unused)}

\item{deriv}{integer argument to psigamma}

\item{a, b}{arguments of beta and lbeta (dual or nueumeric)}

\item{n}{first argument of choose and lchoose (dual)}

\item{k}{second argument of choose and lchoose (numeric)}
}
\value{
All functions return dual objects.
}
\description{
various mathematical functions and methods
}
\details{
The derivative of `abs` is set to be the function `sign`, so its
derivative in 0 is considered as null. You may want to redefine `abs` using `dualFun1`
to get an undefined derivative.
}
\examples{
x <- dual(1)
y <- log(x)
y
d(y)
}
