% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/describe.R
\name{sf_describe_objects}
\alias{sf_describe_objects}
\title{SObject Basic Information}
\usage{
sf_describe_objects(
  object_names,
  api_type = c("SOAP", "REST"),
  control = list(...),
  ...,
  verbose = FALSE
)
}
\arguments{
\item{object_names}{\code{character}; the name of one or more Salesforce objects
that the function is operating against (e.g. "Account", "Contact", "CustomObject__c").}

\item{api_type}{\code{character}; one of \code{"REST"}, \code{"SOAP"},
\code{"Bulk 1.0"}, or \code{"Bulk 2.0"} indicating which API to use when
making the request.}

\item{control}{\code{list}; a list of parameters for controlling the behavior of
the API call being used. For more information of what parameters are available
look at the documentation for \code{\link{sf_control}}.}

\item{...}{arguments passed to \code{\link{sf_control}}}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{list}
}
\description{
\lifecycle{maturing}

Describes the individual metadata for the specified object.
}
\examples{
\dontrun{
account_metadata <- sf_describe_objects("Account")
account_metadata_SOAP <- sf_describe_objects("Account", api_type="SOAP")
multiple_objs_metadata <- sf_describe_objects(c("Contact", "Lead"))

account_metadata_REST <- sf_describe_objects("Account", api_type="REST")
}
}
\seealso{
\href{https://developer.salesforce.com/docs/atlas.en-us.api_rest.meta/api_rest/resources_sobject_describe.htm}{REST API Documentation}, \href{https://developer.salesforce.com/docs/atlas.en-us.api_rest.meta/api_rest/dome_sobject_describe.htm}{REST API Example}
}
