% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-query.R
\name{unbox_list_elements}
\alias{unbox_list_elements}
\title{Unlist all list elements of length 1 if they are not a list}
\usage{
unbox_list_elements(x)
}
\arguments{
\item{x}{\code{list}; a list to be cleaned.}
}
\value{
\code{list} containing \code{NA} in place of \code{NULL} element values.
}
\description{
This function wraps a simple \code{\link[purrr:modify]{modify_if}} function
to "unbox" list elements. This is helpful when the \code{\link[xml2]{as_list}}
returns elements of XML and the element value is kept as a list of length 1,
even though it could be a single primitive data type (e.g. \code{logical},
\code{character}, etc.).
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
