% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-report.R
\name{simplify_report_metadata}
\alias{simplify_report_metadata}
\title{Simplify the \code{reportMetadata} property of a report}
\usage{
simplify_report_metadata(report_id, verbose = FALSE)
}
\arguments{
\item{report_id}{\code{character}; the Salesforce Id assigned to a created
analytics report. It will start with \code{"00O"}.}

\item{verbose}{\code{logical}; an indicator of whether to print additional
detail for each API call, which is useful for debugging. More specifically, when
set to \code{TRUE} the URL, header, and body will be printed for each request,
along with additional diagnostic information where available.}
}
\value{
\code{list}; a list representing the \code{reportMetadata} property of
the report id provided, but with adjustments made.
}
\description{
This function accepts the Id of a report in Salesforce and returns its
\code{reportMetadata} property with modifications made so that the report
will return a dataset that is closer to a tidy format. More specifically, the
data will be detailed data (not any report aggregates) in a tabular format
with no filters, grand totals, or subtotals.
}
\note{
This function is meant to be used internally. Only use when debugging.
}
\keyword{internal}
