% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map.R
\docType{methods}
\name{map}
\alias{map}
\alias{map,samc,vector-method}
\title{Map vector data}
\usage{
map(samc, vec)

\S4method{map}{samc,vector}(samc, vec)
}
\arguments{
\item{samc}{Spatial absorbing Markov chain object. This should be output from the samc() function.}

\item{vec}{Vector data to fill into the map.}
}
\value{
A RasterLayer object
}
\description{
Map vector data to a RasterLayer
}
\details{
This is a convenience function to ensure that vector data is properly mapped
back to the original landscape data. The reason this is needed is that the
package supports both matrices and RasterLayers, which differ in the order
that data is read and written (R matrices are column-major order, whereas the
raster package uses row-major order). Internally, the package uses only a
single order, regardless of the original data. This can cause issues with
mapping vector results if care is not taken, and this function is provided to
simplify the process. It also correctly maps results for landscape data that
has NA cells, which are another potential source of error if not careful.

The only requirement of the \code{vec} input is that the number of elements
in it matches the number of non-NA cells in the landscape data that was used
to create the samc object.
}
\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::ex_res_data
abs_data <- samc::ex_abs_data
occ_data <- samc::ex_occ_data


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, occ_data)


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers. If using RasterLayers, the latlon parameter must be set.
samc_obj <- samc(res_data, abs_data, tr_fun = function(x) 1/mean(x))


# Convert the occupancy data to probability of occurrence
occ_prob_data <- occ_data / sum(occ_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, occ_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, occ_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
