% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{survival}
\alias{survival}
\alias{survival,samc,missing-method}
\alias{survival,samc,ANY-method}
\title{Calculate survival metrics}
\usage{
survival(samc, occ)

\S4method{survival}{samc,missing}(samc)

\S4method{survival}{samc,ANY}(samc, occ)
}
\arguments{
\item{samc}{A \code{\link{samc-class}} object created using the \code{\link{samc}} function.}

\item{occ}{The initial state \eqn{\psi} of the Markov chain. If the \code{\link{samc-class}}
objects was constructed using map inputs, then occ must be the same type of input
(either \code{\link[raster]{RasterLayer-class}} or \code{\link[base]{matrix}}),
and must have the same properties as initial map inputs (see the \code{\link{check}}
function).}
}
\value{
See Details
}
\description{
Calculates the expected time to absorption
}
\details{
\eqn{z=(I-Q)^{-1}{\cdot}1=F{\cdot}1}
\itemize{
  \item \strong{survival(samc)}

The result is a vector \eqn{\mathbf{v}} where \eqn{\mathbf{v}_i} is the expected
time to absorption if starting at transient state \eqn{\mathit{i}}.

If the samc-class object was created using matrix or RasterLayer maps, then
vector \eqn{\mathbf{v}} can be mapped to a RasterLayer using the
\code{\link{map}} function.
}

\eqn{\psi^Tz}
\itemize{
  \item \strong{survival(samc, occ)}

The result is a numeric that is the expected time to absorption given an initial
state \eqn{\psi}.
}
}
\section{Performance}{


Any relevant performance information about this function can be found in the
performance vignette: \href{../doc/performance.html}{\code{vignette("performance", package = "samc")}}
}

\examples{
# "Load" the data. In this case we are using data built into the package.
# In practice, users will likely load raster data using the raster() function
# from the raster package.
res_data <- samc::ex_res_data
abs_data <- samc::ex_abs_data
occ_data <- samc::ex_occ_data


# Make sure our data meets the basic input requirements of the package using
# the check() function.
check(res_data, abs_data)
check(res_data, occ_data)

# Setup the details for our transition function
tr <- list(fun = function(x) 1/mean(x), # Function for calculating transition probabilities
           dir = 8, # Directions of the transitions. Either 4 or 8.
           sym = TRUE) # Is the function symmetric?


# Create a `samc-class` object with the resistance and absorption data using
# the samc() function. We use the recipricol of the arithmetic mean for
# calculating the transition matrix. Note, the input data here are matrices,
# not RasterLayers.
samc_obj <- samc(res_data, abs_data, tr_args = tr)


# Convert the occupancy data to probability of occurrence
occ_prob_data <- occ_data / sum(occ_data, na.rm = TRUE)


# Calculate short- and long-term metrics using the analytical functions
short_mort <- mortality(samc_obj, occ_prob_data, time = 50)
short_dist <- distribution(samc_obj, origin = 3, time = 50)
long_disp <- dispersal(samc_obj, occ_prob_data)
visit <- visitation(samc_obj, dest = 4)
surv <- survival(samc_obj)


# Use the map() function to turn vector results into RasterLayer objects.
short_mort_map <- map(samc_obj, short_mort)
short_dist_map <- map(samc_obj, short_dist)
long_disp_map <- map(samc_obj, long_disp)
visit_map <- map(samc_obj, visit)
surv_map <- map(samc_obj, surv)
}
