% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-same-number.R
\name{same_number}
\alias{same_number}
\title{Compare Numerical Similarity Across Lists}
\usage{
same_number(
  ...,
  method = c("exact", "raw", "exp", "percent", "normalized", "fuzzy"),
  epsilon = 0.05,
  epsilon_pct = 0.02,
  max_diff = NULL,
  digits = 3
)
}
\arguments{
\item{...}{Two or more lists containing numeric values to compare}

\item{method}{Character vector specifying similarity methods (default: all)}

\item{epsilon}{Threshold for fuzzy matching (default: NULL for auto-calculation)}

\item{epsilon_pct}{Relative epsilon percentile (default: 0.02 or 2\%). Only used when method is "fuzzy"}

\item{max_diff}{Maximum difference for normalization (default: NULL for auto-calculation)}

\item{digits}{Number of digits to round results (default: 3)}
}
\value{
An S3 object containing:
\itemize{
\item \code{scores}: A list of similarity scores for each method and list pair
\item \code{summary}: A list of statistical summaries for each method and list pair
\item \code{methods}: The similarity methods used
\item \code{list_names}: Names of the input lists
\item \code{raw_values}: The original input lists
}
}
\description{
Computes similarity scores between two or more lists of numeric values using multiple comparison methods.
}
\details{
The available methods are:
\itemize{
\item \code{exact}: Binary similarity (1 if equal, 0 otherwise)
\item \code{percent}: Percentage difference relative to the larger value
\item \code{normalized}: Absolute difference normalized by a maximum difference value
\item \code{fuzzy}: Similarity based on an epsilon threshold
\item \code{exp}: Exponential decay based on absolute difference (e^-diff)
\item \code{raw}: Returns the raw absolute difference (|num1 - num2|) instead of a similarity score
}
}
\examples{
nums1 <- list(1, 2, 3)
nums2 <- list(1, 2.1, 3.2)
result <- same_number(nums1, nums2)
}
