% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplers.R
\name{sampler_mc3}
\alias{sampler_mc3}
\title{Metropolis-coupled MCMC sampler (MC3)}
\usage{
sampler_mc3(
  start,
  distr_name = NULL,
  distr_params = NULL,
  sigma_prop = NULL,
  nChains = 6,
  delta_T = 4,
  swap_all = TRUE,
  iterations = 1024L,
  weights = NULL,
  custom_density = NULL,
  alpha = 0
)
}
\arguments{
\item{start}{Either a vector or a matrix. If it is a vector, it will be the starting point of all the chains (with length = number of dimensions). If it's a matrix, every row will be the starting point of one chain (and so it must have as many rows as nChains, and as many columns as number of dimensions in the space).}

\item{distr_name}{Name of the distribution from which to sample from.}

\item{distr_params}{Distribution parameters.}

\item{sigma_prop}{Covariance matrix of the proposal distribution. If sampling in 1D space, it can be instead a number.}

\item{nChains}{Number of chains to run.}

\item{delta_T}{numeric, >1. Temperature increment parameter. The bigger this number, the steeper the increase in temperature between the cold chain and the next chain}

\item{swap_all}{Boolean. If true, every iteration attempts floor(nChains / 2) swaps. If false, only one swap per iteration.}

\item{iterations}{Number of iterations of the sampler.}

\item{weights}{If using a mixture distribution, the weights given to each constituent distribution. If none given, it defaults to equal weights for all distributions.}

\item{custom_density}{Instead of providing names, params and weights, the user may prefer to provide a custom density function.}

\item{alpha}{autocorrelation of proposals parameter, from -1 to 1, with 0 being independent proposals}
}
\value{
A named list containing
\enumerate{
\item{Samples: the history of visited places (an n x d x c array, n = iterations; d = dimensions; c = chain index, with c==1 being the 'cold chain')}
\item{Proposals: the history of proposed places (an n x d x c array, n = iterations; d = dimensions; c = chain index, with c==1 being the 'cold chain'). Nothing is proposed in the first iteration (the first iteration is the start value) and so the first row is NA}
\item{Acceptance Ratio: The proportion of proposals that were accepted (for each chain).}
\item{Beta Values: The set of temperatures used in each chain}
\item{Swap History: the history of chain swaps}
\item{Swap Acceptance Ratio: The ratio of swap acceptances}
}
}
\description{
This sampler is a variant of MH in which multiple parallel chains are run at different temperatures. The chains stochastically swap positions which allows the coldest chain to visit regions far from its starting point (unlike in MH). Because of this, an MC3 sampler can explore far-off regions, whereas an MH sampler may become stuck in a particular point of high density.
}
\details{
This algorithm has been used to model human data in \insertCite{castillo2024ExplainingFlawsHuman;textual}{samplr}, \insertCite{zhu2022UnderstandingStructureCognitive;textual}{samplr} and \insertCite{zhu2018MentalSamplingMultimodal;textual}{samplr} among others.
}
\examples{

# Sample from a normal distribution
result <- sampler_mc3(
    distr_name = "norm", distr_params = c(0,1), 
    start = 1, sigma_prop = diag(1)
)
cold_chain <- result$Samples[,,1]
}
\references{
\insertAllCited{}
}
