% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/santaR_CBand.R
\name{santaR_CBand}
\alias{santaR_CBand}
\title{Compute Group Mean Curve Confidence Bands}
\usage{
santaR_CBand(SANTAObj, nBoot = 1000, alpha = 0.05, subsampling = 250)
}
\arguments{
\item{SANTAObj}{A fitted \emph{SANTAObj} as generated by \code{\link{santaR_fit}}.}

\item{nBoot}{(int) Number of bootstrapping rounds. Default 1000.}

\item{alpha}{(float) Confidence \emph{(0.05 for 95\% Confidence Bands)}. Default 0.05.}

\item{subsampling}{(int) Number of points to sample in the time range (for the estimator and Confidence Bands). Default is 250.}
}
\value{
A \emph{SANTAObj} with added Confidence Bands for each group.
}
\description{
Generate bootstrapped group mean curve Confidence Bands, by resampling of individual curves with replacement. Returns a \emph{SANTAObj} with added Confidence Bands.
\itemize{
  \item Resampling whole data curves assumes less of the data than resampling of residuals.
  \item The resampled distribution is of same size as the original distribution (same number of individuals in each group as in the input data).
  \item The degree of freedom for the estimator is identical to the one employed for curve fitting in \code{\link{santaR_fit}}.
}
}
\examples{
## 56 measurements, 8 subjects, 7 unique time-points
## Default parameter values decreased to ensure an execution < 2 seconds
Yi          <- acuteInflammation$data$var_3
ind         <- acuteInflammation$meta$ind
time        <- acuteInflammation$meta$time
group       <- acuteInflammation$meta$group
grouping    <- get_grouping(ind, group)
inputMatrix <- get_ind_time_matrix(Yi, ind, time)
SANTAObj    <- santaR_fit(inputMatrix, df=5, grouping=grouping, verbose=TRUE)
SANTAObj    <- santaR_CBand(SANTAObj, nBoot=100)

}
\seealso{
Other Analysis: \code{\link{get_grouping}},
  \code{\link{get_ind_time_matrix}},
  \code{\link{santaR_auto_fit}},
  \code{\link{santaR_auto_summary}},
  \code{\link{santaR_fit}}, \code{\link{santaR_plot}},
  \code{\link{santaR_pvalue_dist}},
  \code{\link{santaR_pvalue_fit}},
  \code{\link{santaR_start_GUI}}
}
