% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{scaling_UV}
\alias{scaling_UV}
\title{Unit-Variance scaling of each column}
\usage{
scaling_UV(inputMat)
}
\arguments{
\item{inputMat}{(Observation x Variable) \code{data.frame} of measurements, with observations as rows and different variables as columns.}
}
\value{
Matrix of measurements UV-scaled columnwise.
}
\description{
Unit-Variance (UV) scale each variable (column). UV-scaling applied as (value - mean) / stdev.
Unit-Variance Scaling or Autoscaling, is commonly applied and uses the standard deviation as the scaling factor. After autoscaling, all metabolites have a standard deviation of one and therefore the data is analyzed on the basis of correlations instead of covariances.
}
\examples{
\dontrun{
inputMat <- data.frame(matrix(c(1,4,7, 8,4,0, 3,6,9), nrow=3))
scaling_UV(inputMat)
#       X1 X2 X3
# [1,] -1  1 -1
# [2,]  0  0  0
# [3,]  1 -1  1
}
}
