% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chop.R
\name{chop}
\alias{chop}
\alias{kiru}
\title{Cut numeric data into intervals}
\usage{
chop(x, breaks, labels, extend = NULL, drop = TRUE)

kiru(x, breaks, labels, extend = NULL, drop = TRUE)
}
\arguments{
\item{x}{A numeric vector.}

\item{breaks}{See below.}

\item{labels}{See below.}

\item{extend}{Logical. Extend breaks to \verb{+/-Inf}?}

\item{drop}{Logical. Drop unused levels from the result?}
}
\value{
A \link{factor} of the same length as \code{x}, representing the intervals containing
the value of \code{x}.
}
\description{
\code{chop} cuts \code{x} into intervals. It returns a factor of the same
length as \code{x}, representing which interval contains each element of \code{x}.
}
\details{
\code{breaks} may be a numeric vector or a function.

If it is a vector, \code{breaks} gives the break endpoints.Repeated values create
singleton intervals. For example \code{breaks = c(1, 3, 3, 5)} creates 3
intervals: \code{[1, 3)}, \code{{3}} and \code{(3, 5]}. Default breaks are
left-closed except for the last interval; for right-closed breaks see
\code{\link[=brk_right]{brk_right()}}.

If \code{breaks} is a function it is called with a single argument, \code{x}, and
returns an object of class \code{breaks}.

\code{labels} may be a character vector. It should have the same length as the
number of intervals. Alternatively, use a \code{lbl_} function such as
\code{\link[=lbl_seq]{lbl_seq()}}.

If \code{extend} is \code{TRUE}, intervals will be extended to \code{[-Inf,
min(breaks))} and \code{(max(breaks), Inf]}.

If \code{extend} is \code{NULL} (the default), intervals will be extended to
\code{[min(x), min(breaks))} and \code{(max(breaks), max(x)]}, \emph{only} if
necessary -- i.e. if \code{min(x) < min(breaks)} and \code{max(x) > max(breaks)}
respectively.

\code{NA} values in \code{x}, and values which are outside the (extended) endpoints,
return \code{NA}.

Note that \code{chop}, like all of R, uses binary arithmetic. Thus, numbers may
not be exactly equal to what you think they should be. There is an example
below.

\code{kiru} is a synonym for \code{chop}. If you load \code{tidyr}, you can use it to avoid
confusion with \code{tidyr::chop()}.
}
\examples{
chop(1:3, 2)

chop(1:10, c(2, 5, 8))

chop(1:10, c(2, 5, 8), extend = FALSE)

chop(1:10, c(2, 5, 5, 8))

chop(1:10, brk_quantiles(c(0.25, 0.75)))

chop(1:10, c(2, 5, 8), labels = lbl_dash())

# floating point inaccuracy:
chop(0.3/3, c(0, 0.1, 0.1, 1))

}
\seealso{
cut

Other chopping functions: 
\code{\link{brk_mean_sd}()},
\code{\link{brk_n}()},
\code{\link{brk_quantiles}()},
\code{\link{brk_width}()},
\code{\link{fillet}()}
}
\concept{chopping functions}
