% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tweet_acquire.R
\name{tweet_acquire}
\alias{tweet_acquire}
\title{Acquire Twitter Tweets}
\usage{
tweet_acquire(
  twitter_app,
  consumer_api_key,
  consumer_api_secret_key,
  access_token,
  access_token_secret,
  query,
  num_tweets,
  reduced_tweets = TRUE,
  distinct = TRUE
)
}
\arguments{
\item{twitter_app}{The name of user created Twitter Application.}

\item{consumer_api_key}{Twitter Application management consumer API key.}

\item{consumer_api_secret_key}{Twitter Application management consumer API
secret key.  Application must have \code{Read and write} access level and
\code{Callback URL} of \code{http://127.0.0.1:1410}.}

\item{access_token}{Twitter Application management access token 
(apps.twitter.com).}

\item{access_token_secret}{Twitter Application management access secret 
token (apps.twitter.com).}

\item{query}{A single query or a list of queries the user has specified.
Character string, not to exceed 500 characters.  To search for tweets 
containing at least one of multiple possible terms, separate each search 
term with spaces and "OR" (in caps).  For example, the search \code{q =
"data science"} looks for tweets containing both "data" and "science" 
located anywhere in the tweets and in any order.  When "OR" is entered 
between search terms, \code{query = "data OR science"}, Twitter's REST API 
should return any tweet that contains either "data" or "science."}

\item{num_tweets}{Number of Tweets to be acquired per each hashtag.}

\item{reduced_tweets}{Logical.  If reduced_tweets = TRUE, the data frame 
returned to the user will be significantly reduced specifically for use in 
the `saotd` package.  If reduced_tweets = FALSE, the full results from the 
Twitter API will be returned.}

\item{distinct}{Logical.  If distinct = TRUE, the function removes multiple 
Tweets that originate from the same Twitter id at the exact same time.}
}
\value{
A Data Frame with tweets and meta data.
}
\description{
Function will enable a user to access the Twitter API through
  the [Twitter Developers Account](https://dev.twitter.com/) site.  Once a
  user has a Twitter developers account and has received their individual
  consumer key, consumer secret key, access token, and access secret they
  can acquire Tweets based on a list of hashtags and a requested number of
  entries per query.
}
\examples{
\dontrun{
twitter_app <- "super_app"
consumer_api_key <- "XXXXXXXXXXXXXXXXXXXXXXXXX"
consumer_api_secret_key <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
access_token <- "XXXXXXXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
access_token_secret <- "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"

tweets <- tweet_acquire(
  twitter_app = "twitter_app",
  consumer_api_key = consumer_api_key,
  consumer_api_secret_key = consumer_api_secret_key,
  access_token = access_token,
  access_token_secret = access_token_secret,
  query = "#icecream",
  num_tweets = 100,
  distinct = TRUE)

Or the Twitter API keys and tokens can be saved as an .Renviron file in the 
working directory.  If using a `.Renviron` file, the data should be saved 
like the below example:

consumer_api_key=XXXXXXXXXXXXXXXXXXXXXXXXX
consumer_api_secret_key=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
access_token=XXXXXXXXXXXXXXXXXX-XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
access_token_secret=XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX

The `tweet_acquire` function would access the keys and tokens using the 
`Sys.getenv()` function and would appear like the below example:

tweets <- tweet_acquire(
  twitter_app = "twitter_app",
  consumer_api_key = Sys.getenv('consumer_api_key'),
  consumer_api_secret_key = Sys.getenv('consumer_api_secret_key'),
  access_token = Sys.getenv('access_token'),
  access_token_secret = Sys.getenv('access_token_secret'),
  query = "#icecream",
  num_tweets = 100,
  distinct = TRUE)

}
}
