% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbind.snowprofileSet.R
\name{rbind.snowprofileSet}
\alias{rbind.snowprofileSet}
\title{Concatenate snowprofileSet into a large data.frame with a row for each layer}
\usage{
\method{rbind}{snowprofileSet}(..., deparse.level = 1)
}
\arguments{
\item{...}{Object of class \link{snowprofileSet}}

\item{deparse.level}{Argument for generic rbind method}
}
\value{
data.frame
}
\description{
A wrapper to apply \link{rbind.snowprofile} to each profile in a \link{snowprofileSet} then concatenate
}
\details{
Returns a large data.frame with a row for each layer and additional columns with metadata (calculated with \link{summary.snowprofile})
}
\examples{

## Create rbind table
ProfileTable <- rbind(SPgroup)
head(ProfileTable)

## Filter by layer properties
SHlayers <- subset(ProfileTable, gtype == 'SH')
summary(SHlayers)
plot(elev ~ gsize, SHlayers)

}
\seealso{
\link{summary.snowprofile}, \link{rbind.snowprofile}
}
\author{
shorton
}
