% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_plot.R
\name{plot.threshold}
\alias{plot.threshold}
\title{Plot Model Fits for a 'threshold' Object}
\usage{
\method{plot}{threshold}(
  x,
  xlab = NULL,
  ylab = NULL,
  multPlot = TRUE,
  pch = 16,
  cex = 1.2,
  pcol = "black",
  ModTitle = NULL,
  TiAdj = 0,
  TiLine = 0.5,
  cex.main = 1.5,
  cex.lab = 1.3,
  cex.axis = 1,
  yRange = NULL,
  lwd = 2,
  lcol = "red",
  di = NULL,
  ...
)
}
\arguments{
\item{x}{An object of class 'threshold'.}

\item{xlab}{Title for the x-axis. Defaults will depend on any axes
log-transformations.}

\item{ylab}{Title for the y-axis.Defaults will depend on any axes
log-transformations.}

\item{multPlot}{Whether separate plots should be built for each model fit
(default = TRUE) or all model fits should be printed on the same plot
(FALSE)}

\item{pch}{Plotting character (for points).}

\item{cex}{A numerical vector giving the amount by which plotting symbols
(points) should be scaled relative to the default.}

\item{pcol}{Colour of the points.}

\item{ModTitle}{Plot title (default is \code{ModTitle = NULL}), which reverts
to the model names. For no title, use \code{ModTitle = ""}.}

\item{TiAdj}{Which way the plot title is justified.}

\item{TiLine}{Places the plot title this many lines outwards from the plot
edge.}

\item{cex.main}{The amount by which the plot title should be scaled relative
to the default.}

\item{cex.lab}{The amount by which the axis titles should be scaled relative
to the default.}

\item{cex.axis}{The amount by which the axis labels should be scaled relative
to the default.}

\item{yRange}{The range of the y-axis. Default taken as the largest value
bacross the observed and fitted values.}

\item{lwd}{Line width.}

\item{lcol}{Line colour. If \code{multPlot = TRUE}, just a single colour
should be given, If  \code{multPlot = FALSE}, either a single colour, or a
vector of colours the same length as the number of model fits in \code{x}.}

\item{di}{Dimensions to be passed to \code{par(mfrow=())} to specify the size
of the plotting window, when plotting multiple plots. For example, \code{di
= c(1, 3)} creates a plotting window with 1 row and 3 columns. The default
(\code{NULL}) creates a plotting window large enough to fit all plots in.}

\item{\dots}{Further graphical parameters (see \code{\link[graphics]{par}},
\code{\link[graphics]{plot.default}},\code{\link[graphics]{title}},
\code{\link[graphics]{lines}}) may be supplied as arguments.}
}
\description{
S3 method for class 'threshold'. \code{plot.threshold} creates
 plots for objects of class threshold, using the R base plotting framework.
 Plots of single or multiple threshold models can be constructed.
}
\note{
The raw \code{\link{lm}} model fit objects are returned with the
 \code{\link{sar_threshold}} function if the user wishes to construct their
 own plots.
 
 Use \code{par(mai = c())} prior to calling plot, to set the graph margins,
 which can be useful when plotting multiple models in a single plot to ensure
 space within the plot taken up by the individual model fit plots is
 maximised.
}
\examples{
data(aegean)

#fit two threshold models (in logA-S space) and the linear and 
#intercept only models
fct <- sar_threshold(aegean, mod = c("ContOne", "DiscOne"),
                    non_th_models = TRUE,  interval = 5,
                    parallel = FALSE, logAxes = "area")

#plot using default settings
plot(fct)

#change various plotting settings, and set the graph margins prior to
#plotting
par(mai = c(0.7,0.7, 0.4, 0.3))
plot(fct, pcol = "blue", pch = 18, lcol = "green",
    ModTitle = c("A", "B", "C", "D"), TiAdj = 0.5, xlab = "Yorke")
    
#Plot multiple model fits in the same plot, with different colour for each 
#model fit
plot(fct, multPlot = FALSE, lcol = c("black", "red", "green", "purple"))
}
