library(sasLM)

f1 = yield ~ block + N*P*K
GLM(f1, npk)
REG(f1, npk)
EMS(f1, npk)
lr(f1, npk)
lr0(f1, npk)
aov1(f1, npk)
aov2(f1, npk)
aov3(f1, npk)

f1b = yield ~ block + N*P*K - 1
GLM(f1b, npk[-1, ])
REG(f1b, npk[-1, ])
EMS(f1b, npk[-1, ])
lr(f1b, npk[-1, ])
lr0(f1b, npk[-1, ])
aov1(f1b, npk[-1, ])
aov2(f1b, npk[-1, ])
aov3(f1b, npk[-1, ])

f2 = weight ~ feed
GLM(f2, chickwts)
REG(f2, chickwts)
EMS(f2, chickwts)
lr(f2, chickwts)
lr0(f2, chickwts)
aov1(f2, chickwts)
aov2(f2, chickwts)
aov3(f2, chickwts)

f3 = uptake ~ conc - 1
GLM(f3, CO2)
REG(f3, CO2)
EMS(f3, CO2)
lr(f3, CO2)
lr0(f3, CO2)
aov1(f3, CO2)
aov2(f3, CO2)
aov3(f3, CO2)

Coll(mpg ~ disp + hp + drat + wt + qsec, mtcars)
Coll(mpg ~ disp + hp + drat + wt + qsec - 1, mtcars)

RD(7, 10, 3, 10)
RDmn1(7, 10, 3, 10)
RDmn(data.frame(y1=7, n1=10, y2=3, n2=10))
RDinv(data.frame(y1=7, n1=10, y2=3, n2=10))
RDmn(data.frame(y1=c(25, 23), n1=c(339, 370), y2=c(28, 40), n2=c(335, 364)))
RDinv(data.frame(y1=c(25, 23), n1=c(339, 370), y2=c(28, 40), n2=c(335, 364)))

RR(7, 10, 3, 10)
RRmn1(7, 10, 3, 10)
RRmn(data.frame(y1=7, n1=10, y2=3, n2=10))
RRinv(data.frame(y1=7, n1=10, y2=3, n2=10))
RRmn(data.frame(y1=c(25, 23), n1=c(339, 370), y2=c(28, 40), n2=c(335, 364)))
RRinv(data.frame(y1=c(25, 23), n1=c(339, 370), y2=c(28, 40), n2=c(335, 364)))

OR(7, 10, 3, 10)
ORmn1(7, 10, 3, 10)
ORmn(data.frame(y1=7, n1=10, y2=3, n2=10))
ORinv(data.frame(y1=7, n1=10, y2=3, n2=10))
ORcmh(data.frame(y1=7, n1=10, y2=3, n2=10))
ORmn(data.frame(y1=c(25, 23), n1=c(339, 370), y2=c(28, 40), n2=c(335, 364)))
ORinv(data.frame(y1=c(25, 23), n1=c(339, 370), y2=c(28, 40), n2=c(335, 364)))
ORcmh(data.frame(y1=c(25, 23), n1=c(339, 370), y2=c(28, 40), n2=c(335, 364)))

## Test of extreme input values

ScoreCI(0, 1)
ScoreCI(0, 2)
ScoreCI(0, 10)
ScoreCI(0, 1e308)
ScoreCI(1, 1)
ScoreCI(10, 10)
ScoreCI(1e308, 1e308)

LIbin(0, 1)
LIbin(0, 2)
LIbin(0, 10)
LIbin(0, 1e308)
LIbin(1, 1)
LIbin(10, 10)
LIbin(1e308, 1e308)

RD(0, 1, 0, 1)
RD(0, 1, 1, 1)
RD(0, 10, 0, 10)
RD(0, 10, 10, 10)
RD(0, 1e308, 0, 1e308)
RD(0, 1e308, 1e308, 1e308)
RD(1, 1, 0, 1)
RD(1, 1, 1, 1)
RD(10, 10, 0, 10)
RD(10, 10, 10, 10)
RD(1e308, 1e308, 0, 1e308)
RD(1e308, 1e308, 1e308, 1e308)

RDLI(0, 1, 0, 1)
RDLI(0, 1, 1, 1)
RDLI(0, 10, 0, 10) # 0k
RDLI(0, 10, 10, 10)
RDLI(0, 1e8, 0, 1e8)
RDLI(0, 1e8, 1e8, 1e8)
RDLI(1, 1, 0, 1)
RDLI(1, 1, 1, 1)
RDLI(10, 10, 0, 10)
RDLI(10, 10, 10, 10)
RDLI(1e8, 1e8, 0, 1e8)
RDLI(1e8, 1e8, 1e8, 1e8)

RDinv(data.frame(y1=0, n1=1, y2=0, n2=1))
RDinv(data.frame(y1=0, n1=1, y2=1, n2=1))
RDinv(data.frame(y1=0, n1=10, y2=0, n2=10))
RDinv(data.frame(y1=0, n1=10, y2=10, n2=10))
RDinv(data.frame(y1=1, n1=1, y2=0, n2=1))
RDinv(data.frame(y1=1, n1=1, y2=1, n2=1))
RDinv(data.frame(y1=10, n1=10, y2=0, n2=10))
RDinv(data.frame(y1=10, n1=10, y2=10, n2=10))
RDinv(data.frame(y1=0, n1=1e308, y2=0, n2=1e308))
RDinv(data.frame(y1=0, n1=1e308, y2=1e308, n2=1e308))
RDinv(data.frame(y1=1e308, n1=1e308, y2=0, n2=1e308))
RDinv(data.frame(y1=1e308, n1=1e308, y2=1e308, n2=1e308))

RDmn1(0, 1, 0, 1)
RDmn1(0, 1, 1, 1)
RDmn1(0, 10, 0, 10)
RDmn1(0, 10, 10, 10)
RDmn1(1, 1, 0, 1)
RDmn1(1, 1, 1, 1)
RDmn1(10, 10, 0, 10)
RDmn1(10, 10, 10, 10)
RDmn1(0, 1e8, 0, 1e8)
RDmn1(0, 1e8, 1e8, 1e8)
RDmn1(1e8, 1e8, 0, 1e8)
RDmn1(1e8, 1e8, 1e8, 1e8)

RDmn(data.frame(y1=0, n1=1, y2=0, n2=1))
RDmn(data.frame(y1=0, n1=1, y2=1, n2=1))
RDmn(data.frame(y1=0, n1=10, y2=0, n2=10))
RDmn(data.frame(y1=0, n1=10, y2=10, n2=10))
RDmn(data.frame(y1=1, n1=1, y2=0, n2=1))
RDmn(data.frame(y1=1, n1=1, y2=1, n2=1))
RDmn(data.frame(y1=10, n1=10, y2=0, n2=10))
RDmn(data.frame(y1=10, n1=10, y2=10, n2=10))
RDmn(data.frame(y1=0, n1=1e8, y2=0, n2=1e8))
RDmn(data.frame(y1=0, n1=1e8, y2=1e8, n2=1e8))
RDmn(data.frame(y1=1e8, n1=1e8, y2=0, n2=1e8))
RDmn(data.frame(y1=1e8, n1=1e8, y2=1e8, n2=1e8))

RR(0, 1, 0, 1)
RR(0, 1, 1, 1)
RR(0, 10, 0, 10)
RR(0, 10, 10, 10)
RR(0, 1e308, 0, 1e308)
RR(0, 1e308, 1e308, 1e308)
RR(1, 1, 0, 1)
RR(1, 1, 1, 1)
RR(10, 10, 0, 10)
RR(10, 10, 10, 10)
RR(1e308, 1e308, 0, 1e308)
RR(1e308, 1e308, 1e308, 1e308)

RRinv(data.frame(y1=0, n1=1, y2=0, n2=1))
RRinv(data.frame(y1=0, n1=1, y2=1, n2=1))
RRinv(data.frame(y1=0, n1=10, y2=0, n2=10))
RRinv(data.frame(y1=0, n1=10, y2=10, n2=10))
RRinv(data.frame(y1=1, n1=1, y2=0, n2=1))
RRinv(data.frame(y1=1, n1=1, y2=1, n2=1))
RRinv(data.frame(y1=10, n1=10, y2=0, n2=10))
RRinv(data.frame(y1=10, n1=10, y2=10, n2=10))
RRinv(data.frame(y1=0, n1=1e308, y2=0, n2=1e308))
RRinv(data.frame(y1=0, n1=1e308, y2=1e308, n2=1e308))
RRinv(data.frame(y1=1e308, n1=1e308, y2=0, n2=1e308))
RRinv(data.frame(y1=1e308, n1=1e308, y2=1e308, n2=1e308))

RRmn1(0, 1, 0, 1)
RRmn1(0, 1, 1, 1)
RRmn1(1, 1, 0, 1)
RRmn1(1, 1, 1, 1)

RRmn1(0, 2, 0, 2)
RRmn1(0, 2, 1, 2)
RRmn1(0, 2, 2, 2)
RRmn1(1, 2, 0, 2)
RRmn1(1, 2, 1, 2)
RRmn1(1, 2, 2, 2)
RRmn1(2, 2, 0, 2)
RRmn1(2, 2, 1, 2)
RRmn1(2, 2, 2, 2)

RRmn1(0, 30, 0, 30)
RRmn1(0, 30, 15, 30)
RRmn1(0, 30, 30, 30)
RRmn1(15, 30, 0, 30)
RRmn1(15, 30, 5, 30)
RRmn1(15, 30, 30, 30)
RRmn1(30, 30, 0, 30)
RRmn1(30, 30, 15, 30)
RRmn1(30, 30, 30, 30)

RRmn(data.frame(y1=0, n1=1, y2=0, n2=1))
RRmn(data.frame(y1=0, n1=1, y2=1, n2=1))
RRmn(data.frame(y1=0, n1=10, y2=0, n2=10))
RRmn(data.frame(y1=0, n1=10, y2=10, n2=10))
RRmn(data.frame(y1=1, n1=1, y2=0, n2=1))
RRmn(data.frame(y1=1, n1=1, y2=1, n2=1))
RRmn(data.frame(y1=10, n1=10, y2=0, n2=10))
RRmn(data.frame(y1=10, n1=10, y2=10, n2=10))
RRmn(data.frame(y1=0, n1=1e8, y2=0, n2=1e8))
RRmn(data.frame(y1=0, n1=1e8, y2=1e8, n2=1e8))
RRmn(data.frame(y1=1e8, n1=1e8, y2=0, n2=1e8))
RRmn(data.frame(y1=1e8, n1=1e8, y2=1e8, n2=1e8))

OR(0, 1, 0, 1)
OR(0, 1, 1, 1)
OR(0, 10, 0, 10)
OR(0, 10, 10, 10)
OR(0, 1e308, 0, 1e308)
OR(0, 1e308, 1e308, 1e308)
OR(1, 1, 0, 1)
OR(1, 1, 1, 1)
OR(10, 10, 0, 10)
OR(10, 10, 10, 10)
OR(1e308, 1e308, 0, 1e308)
OR(1e308, 1e308, 1e308, 1e308)

ORcmh(data.frame(y1=0, n1=1, y2=0, n2=1))
ORcmh(data.frame(y1=0, n1=1, y2=1, n2=1))
ORcmh(data.frame(y1=1, n1=1, y2=0, n2=1))
ORcmh(data.frame(y1=1, n1=1, y2=1, n2=1))
ORcmh(data.frame(y1=0, n1=10, y2=0, n2=10))
ORcmh(data.frame(y1=0, n1=10, y2=10, n2=10))
ORcmh(data.frame(y1=10, n1=10, y2=0, n2=10))
ORcmh(data.frame(y1=10, n1=10, y2=10, n2=10))
ORcmh(data.frame(y1=0, n1=1e308, y2=0, n2=1e308))
ORcmh(data.frame(y1=0, n1=1e308, y2=1e308, n2=1e308))
ORcmh(data.frame(y1=1e308, n1=1e308, y2=0, n2=1e308))
ORcmh(data.frame(y1=1e308, n1=1e308, y2=1e308, n2=1e308))

ORmn1(0, 1, 0, 1)
ORmn1(0, 1, 1, 1)
ORmn1(1, 1, 0, 1)
ORmn1(1, 1, 1, 1)

ORmn1(0, 10, 0, 10)
ORmn1(0, 10, 5, 10)
ORmn1(0, 10, 10, 10)
ORmn1(5, 10, 0, 10)
ORmn1(5, 10, 5, 10)
ORmn1(5, 10, 10, 10)
ORmn1(10, 10, 0, 10)
ORmn1(10, 10, 5, 10)
ORmn1(10, 10, 10, 10)

ORmn1(0, 1e8, 0, 1e8)
ORmn1(0, 1e4, 1e4, 1e4)
ORmn1(1e4, 1e4, 0, 1e4)
ORmn1(1e8, 1e8, 1e8, 1e8)

ORmn1(0, 1, 0, 1)
ORmn1(1e-2, 1, 1, 1)
ORmn1(0, 10, 0, 10)
ORmn1(1e-2, 10, 10, 10)
ORmn1(1, 1, 1e-2, 1)
ORmn1(1, 1, 1, 1)
ORmn1(10, 10, 1e-2, 10)
ORmn1(10, 10, 10, 10)

ORmn(data.frame(y1=0, n1=1, y2=0, n2=1))
ORmn(data.frame(y1=0, n1=1, y2=1, n2=1))
ORmn(data.frame(y1=1, n1=1, y2=0, n2=1))
ORmn(data.frame(y1=1, n1=1, y2=1, n2=1))
ORmn(data.frame(y1=0, n1=10, y2=0, n2=10))
ORmn(data.frame(y1=0, n1=10, y2=10, n2=10))
ORmn(data.frame(y1=10, n1=10, y2=0, n2=10))
ORmn(data.frame(y1=10, n1=10, y2=10, n2=10))
ORmn(data.frame(y1=0, n1=1e308, y2=0, n2=1e308))
ORmn(data.frame(y1=0, n1=1e4, y2=1e4, n2=1e4))
ORmn(data.frame(y1=1e4, n1=1e4, y2=0, n2=1e4))
ORmn(data.frame(y1=1e308, n1=1e308, y2=1e308, n2=1e308))
