% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights_for_population.R
\name{weights_for_population}
\alias{weights_for_population}
\title{Calculates survey weights given respondent information and target population demographics}
\usage{
weights_for_population(respondentdata, targetdata)
}
\arguments{
\item{respondentdata}{Dataset with encoded respondent demographic information (use encode.cloud.respondent.variables to prepare respondentdata) must have a ParticipantId variable.}

\item{targetdata}{A one row data.frame (or named vector) with the following statistics: black, ba_or_more, hhincome_over50k, age35plus, woman, hispanic (use target.population.demographics to obtain)}
}
\value{
Returns respondentdata with raked sampling weights encoded.
}
\description{
Calculates survey weights given respondent information and target population demographics. Respondent
             demographic info must be properly encoded in respondentdata to work with the target.demographics. If
             respondent demographic info is missing, the respondent's weight will be coded 1. Weight values trimmed
             so that no weights are greater than 6 or less than .1.
}
\examples{
   library(sate)

   example_n <- 100
   example <- data.frame(Race = sample(x=c("Black or African American", "Other"),
                                       size=example_n, replace=TRUE),
                         Education = sample(x=c("Bachelor's degree (for example: BA, AB, BS)",
                                            "Other"), size=example_n, replace=TRUE),
                         Household.Income = sample(x=c("$70,000-$79,999", "Other"),
                                                   size=example_n, replace=TRUE),
                         Age = sample(x=18:80, size=example_n, replace=TRUE),
                         Gender = sample(x=c("Woman", "Man", "Prefer not to say"),
                                         size=example_n, replace=TRUE),
                         Ethnicity = sample(x=c("No, not of Hispanic, Latino, or Spanish origin",
                                            "Other"), size=example_n, replace=TRUE),
                         ParticipantId = 1:example_n)
   respondents.encoded <- encode.cloud.respondent.variables(dataset=example)

   pop.targets <- target.population.demographics(state="FL")

   respondents.weighted <- weights_for_population(respondentdata = respondents.encoded,
                                                  targetdata = pop.targets)

}
