% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_sbo_preds.R
\name{build_sbo_preds}
\alias{build_sbo_preds}
\title{Stupid Back-off predictions.}
\usage{
build_sbo_preds(freqs, lambda = 0.4, L = 3L, filtered = "<UNK>")
}
\arguments{
\item{freqs}{a \code{kgram_freqs} object, containing k-gram
frequencies extracted from a training corpus.}

\item{lambda}{a length one numeric. Penalization in the
Stupid Back-off algorithm.}

\item{L}{a length one integer. Maximum number of next-word predictions
for a given input.}

\item{filtered}{a character vector. Words to exclude from predictions.}
}
\value{
A \code{sbo_preds} object.
}
\description{
Build Stupid Back-off prediction tables from k-gram
frequencies observed in a training corpus.
}
\details{
This function compiles "prediction tables" from which top-scoring
next-word predictions of a Stupid Back-off language model can be read off.
This is done with the purposes of memory compression and efficiency.

The return value is a \code{sbo_preds} object, i.e. a list containing:
\enumerate{
\item The order of the underlying N-gram model, "\code{N}".
\item The maximum number of next-word predictions for a given text input.
\item The model dictionary.
\item A list of tibbles storing prediction tables. These are for internal use
in the \code{\link[sbo]{predict.sbo_preds}} method.
\item The function used for text preprocessing.
\item A length one character vector listing all (single character)
end-of-sentence tokens.
}
}
\examples{
\donttest{
# Train an N-gram model
## Get Stupid Back-off prediction tables
preds <- build_sbo_preds(twitter_freqs)
## Print result
preds
## ...start playing
predict(preds, "i love")
}
}
\seealso{
\code{\link[sbo]{predict.sbo_preds}}
}
\author{
Valerio Gherardi
}
