% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sbpiper_pe.r
\name{compute_sampled_ple_stats}
\alias{compute_sampled_ple_stats}
\title{Compute the table for the sampled PLE statistics.}
\usage{
compute_sampled_ple_stats(df, min_objval, cl66_objval, cl95_objval, cl99_objval,
  logspace = TRUE)
}
\arguments{
\item{df}{the complete data frame}

\item{min_objval}{the minimum objective value}

\item{cl66_objval}{the 66\% confidence level objective value}

\item{cl95_objval}{the 95\% confidence level objective value}

\item{cl99_objval}{the 99\% confidence level objective value}

\item{logspace}{true if parameters are plotted in logspace (default: TRUE)}
}
\value{
the list of parameter values with their confidence intervals
}
\description{
Compute the table for the sampled PLE statistics.
}
\examples{
data(insulin_receptor_all_fits)
colnames(insulin_receptor_all_fits)[1] <- "ObjVal"
min_objval <- min(insulin_receptor_all_fits[,1])
# compute the stats for parameter k2. 
insulin_receptor_all_fits <- subset(insulin_receptor_all_fits, select=c(1,3))
compute_sampled_ple_stats(df=insulin_receptor_all_fits, 
                          min_objval=min_objval, 
                          cl66_objval=min_objval+0.01, 
                          cl95_objval=min_objval+0.02, 
                          cl99_objval=min_objval+0.03, 
                          logspace=FALSE)
}
