% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/items_rm.R
\name{items_rm}
\alias{items_rm}
\title{Remove items from SB}
\usage{
items_rm(sb_id, ..., recursive = FALSE, session = current_session())
}
\arguments{
\item{sb_id}{An \code{\link{sbitem}} object or a character ScienceBase ID corresponding to the item}

\item{...}{Additional parameters are passed on to \code{\link[httr]{GET}}, \code{\link[httr]{POST}},
\code{\link[httr]{HEAD}}, \code{\link[httr]{PUT}}, or \code{\link[httr]{DELETE}}}

\item{recursive}{logical, FALSE by default. CAUTION: setting recursive=TRUE
means that not only will this item be deleted, but so will all its child
items and their child items and so on.}

\item{session}{Session object from \code{\link{authenticate_sb}}. Defaults to anonymous or 
last authenticated session}
}
\value{
\pkg{httr} \code{\link[httr]{response}} object
}
\description{
FIXME: not working yet - httr doesn't allow body in DELETE
}
\examples{
\dontrun{
# helper function to make a random name
aname <- function() paste0(sample(letters, size = 5, replace = TRUE), collapse = "")

# Create some items - by default we use your user ID
res <- items_create(title = c(aname(), aname()))
items_rm(res)
}
}
\keyword{internal}

