% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analysis.R
\name{scDHA.pt}
\alias{scDHA.pt}
\title{scDHA pseudo time inference}
\usage{
scDHA.pt(sc = sc, start.point = 1, ncores = 10L, seed = NULL)
}
\arguments{
\item{sc}{Embedding object, produced by \code{scDHA} function.}

\item{start.point}{Starting point of the trajectory.}

\item{ncores}{Number of processor cores to use.}

\item{seed}{Seed for reproducibility.}
}
\value{
List with the following keys:
\itemize{
\item pt - Pseudo-time values for each sample.
}
}
\description{
Inferring pseudo-time data.
}
\examples{
\donttest{
library(scDHA)
#Load example data (Goolam dataset)
data('Goolam'); data <- t(Goolam$data); label <- as.character(Goolam$label)
#Log transform the data 
data <- log2(data + 1)
#Generate clustering result, the input matrix has rows as samples and columns as genes
result <- scDHA(data, ncores = 2, seed = 1)
#Cell stage order in Goolam dataset
cell.stages <- c("2cell", "4cell", "8cell", "16cell", "blast")
#Generate pseudo-time for each cell, the input is the output from scDHA function
result <- scDHA.pt(result, start.point = 1, ncores = 2, seed = 1)
#Calculate R-squared value 
r2 <- round(cor(result$pt, as.numeric(factor(label, levels = cell.stages)))^2, digits = 2)
}
}
