% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tucker.R
\name{plot_donor_sig_genes}
\alias{plot_donor_sig_genes}
\title{Generate a gene by donor heatmap showing scaled expression of top loading genes
for a given factor}
\usage{
plot_donor_sig_genes(
  container,
  factor_select,
  top_n_per_ctype,
  ctypes_use = NULL,
  show_donor_labels = FALSE,
  additional_meta = NULL,
  add_genes = NULL
)
}
\arguments{
\item{container}{environment Project container that stores sub-containers
for each cell type as well as results and plots from all analyses}

\item{factor_select}{numeric The factor to query}

\item{top_n_per_ctype}{numeric Vector of the number of top genes from each cell type
to plot}

\item{ctypes_use}{character The cell types for which to get the top genes to make
callouts for. If NULL then uses all cell types. (default=NULL)}

\item{show_donor_labels}{logical Set to TRUE to display donor labels (default=FALSE)}

\item{additional_meta}{character Another meta variable to plot (default=NULL)}

\item{add_genes}{character Additional genes to plot for all ctypes (default=NULL)}
}
\value{
The project container with a heatmap plot in the slot
container$plots$donor_sig_genes$<Factor#>. This heatmap shows scaled expression
of top loading genes in each cell type for a selected factor.
}
\description{
Generate a gene by donor heatmap showing scaled expression of top loading genes
for a given factor
}
\examples{
test_container <- plot_donor_sig_genes(test_container, factor_select=1,
top_n_per_ctype=2)
}
