% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coEnrich.R
\name{coEnrich}
\alias{coEnrich}
\title{Identify co-expressed cell-types}
\usage{
coEnrich(
  sig,
  gene_list_heatmap,
  background_heatmap,
  study_name,
  outDir,
  toSave = FALSE,
  path = NULL
)
}
\arguments{
\item{sig}{A The number of combinations of significant cell-types to enrich.}

\item{gene_list_heatmap}{Signature matrix of inputted genes in heatmap and the cell-type preferences -- output of heatmap generation.}

\item{background_heatmap}{Signature matrix of background matrix in heatmap and cell-type preferences -- output of heatmap generation.}

\item{study_name}{Name of the outputted table.}

\item{outDir}{Name of the directory this table will be printed in.}

\item{toSave}{Allow scMappR to write files in the current directory (T/F).}

\item{path}{If toSave == TRUE, path to the directory where files will be saved.}
}
\value{
\code{coEnrich} Enrichment of cell-types that are expressed by the same genes, up to 4 sets of cell-types. \cr
}
\description{
This function identifies genes with similar cell-type markers and if those markers are driving enrichment.
}
\details{
This function takes significantly enriched cell-types from the single CT_enrich before testing to see if the genes driving their enrichment are overlapping to a significant proportion using Fisher's exact test.
To save computational time and to not complete this with an incredible number of permutations, scMappR stops at overlapping 5 cell-types.
}
\examples{
\donttest{
# load in signature matrices
data(POA_example)
POA_generes <- POA_example$POA_generes
POA_OR_signature <- POA_example$POA_OR_signature
POA_Rank_signature <- POA_example$POA_Rank_signature
sig <- get_gene_symbol(POA_Rank_signature)
Signature <- POA_Rank_signature
rownames(Signature) <- sig$rowname
genes <- rownames(Signature)[1:60]
heatmap_test <- tissue_scMappR_custom( genes, signature_matrix = Signature,
output_directory =  "scMappR_test", toSave = FALSE)
group_preferences <- heatmap_test$group_celltype_preferences
}
}
