% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherit_roxygen_descriptions.R
\name{.inheritParams}
\alias{.inheritParams}
\title{Dummy function to inherit global descriptions of parameters}
\usage{
.inheritParams(
  data,
  scdf,
  dvar,
  mvar,
  pvar,
  decreasing,
  phases,
  model,
  contrast,
  trend,
  level,
  slope,
  ...
)
}
\arguments{
\item{data}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{scdf}{A single-case data frame. See \code{\link{scdf}} to learn about
this format.}

\item{dvar}{Character string with the name of the dependent variable.
Defaults to the attributes in the scdf file.}

\item{mvar}{Character string with the name of the measurement time variable.
Defaults to the attributes in the scdf file.}

\item{pvar}{Character string with the name of the phase variable. Defaults to
the attributes in the scdf file.}

\item{decreasing}{If you expect data to be lower in the B phase, set
\code{decreasing = TRUE}. Default is \code{decreasing = FALSE}.}

\item{phases}{A vector of two characters or numbers indicating the two phases
that should be compared. E.g., \code{phases = c("A","C")} or \code{phases =
c(2,4)} for comparing the second to the fourth phase. Phases could be
combined by providing a list with two elements. E.g., \code{phases = list(A
= c(1,3), B = c(2,4))} will compare phases 1 and 3 (as A) against 2 and 4
(as B). Default is \code{phases = c("A","B")}.}

\item{model}{Model used for calculating the slope parameter (see Huitema &
McKean, 2000). Default is \code{model = "W"}. Possible values are:
\code{"B&L-B"}, \code{"H-M"}, \code{"W"}, and deprecated \code{"JW"}.}

\item{contrast}{Either "first" or "preceding". "first" contrasts all 
phase-effects to the first phase and "preceding" to the preceding phase.}

\item{trend}{A logical indicating if a trend parameters is included in the
model.}

\item{level}{A logical indicating if a level parameters is included in the
model.}

\item{slope}{A logical indicating if a slope parameters is included in the
model.}

\item{...}{Further arguments passed to the function.}
}
\description{
Dummy function to inherit global descriptions of parameters
}
