% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plm_contrasts.R
\name{add_dummy_variables}
\alias{add_dummy_variables}
\title{Add Dummy Variables for Piecewise Linear Models}
\usage{
add_dummy_variables(
  scdf,
  model = c("W", "H-M", "B&L-B"),
  contrast_level = c("first", "preceding"),
  contrast_slope = c("first", "preceding")
)
}
\arguments{
\item{scdf}{A single-case data frame. See \code{\link[=scdf]{scdf()}} to learn about this
format.}

\item{model}{Model used for calculating the dummy parameters (see Huitema &
McKean, 2000). Default is \code{model = "W"}. Possible values are: \code{"B&L-B"},
\code{"H-M"}, \code{"W"}, and deprecated \code{"JW"}.}

\item{contrast_level}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}

\item{contrast_slope}{Either "first", "preceding" or a contrast matrix. If NA
contrast_level is a copy of contrast.}
}
\description{
Adds dummy variables to an scdf for calculating piecewise linear models.
}
\examples{
add_dummy_variables(
 scdf = exampleABC, 
 model = "W", 
 contrast_level = "first", 
 contrast_slope = "first"
)
}
