% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scf_update_by_implicate.R
\name{scf_update_by_implicate}
\alias{scf_update_by_implicate}
\title{Modify Each Implicate Individually in SCF Data}
\usage{
scf_update_by_implicate(object, f)
}
\arguments{
\item{object}{A \code{scf_mi_survey} object from \code{\link[=scf_load]{scf_load()}}.}

\item{f}{A function that takes a data frame as input and returns a modified data frame.
This function will be applied independently to each implicate.}
}
\value{
A modified \code{scf_mi_survey} object with updated implicate-level designs.
}
\description{
Each household in SCF data is represented by five \emph{implicates}, which reflect
uncertainty from the imputation process. Most transformations — such as computing
log income or assigning categorical bins — can be applied uniformly across implicates
using \code{\link[=scf_update]{scf_update()}}. However, some operations depend on the \emph{internal distribution}
of variables within each implicate. For those, you need to modify each one separately.

This function extracts each implicate from the replicate-weighted survey design,
applies your transformation, and rebuilds the survey design objects accordingly.
}
\details{
Applies a user-defined transformation to each implicate's data frame separately.
This is useful when you need to compute values that depend on the distribution
within each implicate — such as ranks, percentiles, or groupwise comparisons —
which cannot be computed reliably using \code{\link[=scf_update]{scf_update()}}.
}
\section{Use this When}{

\itemize{
\item You need implicate-specific quantiles (e.g., flag households in the top 10\% of wealth)
\item You want to assign percentile ranks (e.g., income percentile by implicate)
\item You are computing statistics within groups (e.g., groupwise z-scores)
\item You need to derive a variable based on implicate-specific thresholds or bins
}
}

\examples{
# Do not implement these lines in real analysis:
# Use functions `scf_download()` and `scf_load()`
td  <- tempdir()
src <- system.file("extdata", "scf2022_mock_raw.rds", package = "scf")
file.copy(src, file.path(td, "scf2022.rds"), overwrite = TRUE)
scf2022 <- scf_load(2022, data_directory = td)

# Example for real analysis: compute implicate-specific z-scores of income
scf2022 <- scf_update_by_implicate(scf2022, function(df) {
  mu <- mean(df$income, na.rm = TRUE)
  sigma <- sd(df$income, na.rm = TRUE)
  df$z_income <- (df$income - mu) / sigma
  df
})

# Verify new variable exists
head(scf2022$mi_design[[1]]$variables$z_income)

# Do not implement these lines in real analysis: Cleanup for package check
unlink("scf2022.rds", force = TRUE)

}
\seealso{
\code{\link[=scf_update]{scf_update()}}
}
