% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coauthors.R
\name{get_coauthors}
\alias{get_coauthors}
\title{Gets the network of coauthors of a scholar}
\usage{
get_coauthors(id, n_coauthors = 5, n_deep = 1)
}
\arguments{
\item{id}{a character string specifying the Google Scholar ID.
If multiple ids are specified, only the first value is used and a
warning is generated.}

\item{n_coauthors}{Number of coauthors to explore. This number should usually be between 1 and 10 as
choosing many coauthors can make the network graph too messy.}

\item{n_deep}{The number of degrees that you want to go down the network. When \code{n_deep} is equal to \code{1}
then \code{grab_coauthor} will only grab the coauthors of Joe and Mary, so Joe -- > Mary --> All coauthors. This can get
out of control very quickly if \code{n_deep} is set to \code{2} or above. The preferred number is \code{1}, the default.}
}
\value{
A data frame with two columns showing all authors and coauthors.
}
\description{
Gets the network of coauthors of a scholar
}
\details{
Considering that scraping each publication for all coauthors is error prone, \code{get_coauthors}
grabs only the coauthors listed on the google scholar profile (on the bottom right of the profile),
not from all publications.
}
\examples{

\dontrun{

library(scholar)
coauthor_network <- get_coauthors('amYIKXQAAAAJ&hl')
plot_coauthors(coauthor_network)
}


}
\seealso{
\code{\link{plot_coauthors}}
}
