% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/post_hoc.R
\name{quadePost}
\alias{quadePost}
\title{Quade post hoc raw p-values}
\usage{
quadePost(data, control = NULL, ...)
}
\arguments{
\item{data}{Data set (matrix or data.frame) to apply the test. The column names are taken as the groups and the values in the matrix are the samples.}

\item{control}{Either the number or the name of the column for the control algorithm. If this parameter is not provided, the all vs all comparison is performed.}

\item{...}{Not used.}
}
\value{
A matrix with all the pairwise raw p-values (all vs. all or all vs. control).
}
\description{
This function computes the raw p-values for the post hoc based on Quade's test.
}
\details{
The test has been implemented according to the version in Garcia \emph{et al.} (2010), pages 2052,2054
}
\examples{
data(data_gh_2008)
quadePost(data.gh.2008)
quadePost(data.gh.2008, control=1)
}
\references{
S. Garcia, A. Fernandez, J. Luengo and F. Herrera (2010) Advanced nonparametric tests for multiple comparisons in the design of experiments in computational intelligence and ata mining: Experimental analysis of power. \emph{Information Sciences}, 180, 2044-2064.
}

