% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/split_df.R
\name{split_df}
\alias{split_df}
\title{Split a dataset}
\usage{
split_df(dt, y = NULL, ratio = 0.7, seed = 618)
}
\arguments{
\item{dt}{A data frame.}

\item{y}{Name of y variable, default is NULL. The input data will split based on the predictor y, if it is provide.}

\item{ratio}{A numeric value, default is 0.7. It indicates the ratio of total rows contained in one split, must less than 1.}

\item{seed}{A random seed, default is 618.}
}
\value{
A list of data frames
}
\description{
Split a dataset into train and test
}
\examples{
# load German credit data
data(germancredit)

# Example I
dt_list = split_df(germancredit, y="creditability")
train = dt_list[[1]]
test = dt_list[[2]]

# dimensions of train and test datasets
lapply(dt_list, dim)


# Example II
dt_list2 = split_df(germancredit, y="creditability", ratio = c(0.5, 0.2))
lapply(dt_list2, dim)

}
