% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microbiome.R
\docType{data}
\name{microbiome}
\alias{microbiome}
\title{16s Microbiome Data for Soil-Transmitted Helminths}
\format{
A dataframe with 300 rows (two rows per individual) and 31 columns:
\describe{
\item{IndividualID}{An integer uniquely specifying the individual.}
\item{Year}{The collection year for the sample. \code{2008} for before treatment. \code{2010} for after treatment.}
\item{Sex}{\code{1} if female, \code{0} otherwise.}
\item{Treatment}{\code{TRUE} if individual given 400mg of albendazole every three months for 1.5 years, \code{FALSE} otherwise.}
\item{Age}{Age at first sample.}
\item{ct_Al}{A Helminth measurement: The qPCR cycle threshold (CT) for \emph{Ascaris lumbricoides} (large roundworm). \emph{Ascaris lumbricoides} can be considered present if the value is 30 or less.}
\item{ct_Na}{A Helminth measurement: The qPCR cycle threshold (CT) for \emph{Necator americanus} (a hookworm). \emph{Necator americanus} can be considered present if the value is 30 or less.}
\item{ct_Ad}{A Helminth measurement: The qPCR cycle threshold (CT) for \emph{Ancylostoma duodenale} (a hookworm). \emph{Ancylostoma duodenale} can be considered present if the value is 30 or less.}
\item{micr_Tt}{A Helminth measurement: The presence of \emph{Trichuris trichiura} as determined by microscopy. A value of \code{TRUE} means \emph{Trichuris trichiura} was detected.}
\item{Helminth}{A Helminth measurement: If any of the above helminths were detected then \code{TRUE}, otherwise \code{FALSE}.}
\item{Remaining columns}{Count prevalence of 18 bacterial phyla and 2 unclassified columns.}
}
}
\source{
\href{http://nematode.net/Data/environmental_interaction/S1_Table.xlsx}{S1_Table.xlsx} from \href{http://nematode.net/NN3_frontpage.cgi?navbar_selection=environmental_interaction&subnav_selection=Indonesia_16s}{http://nematode.net}.
\href{http://nematode.net/Data/environmental_interaction/S1_Table.xlsx}{S1_Table.xlsx} was created by Dr. Bruce A Rosa for \insertCite{martin2019mi;textual}{scorematchingad}. Permission to share this data was obtained from Dr. Bruce Rosa and Dr. Ivonne Martin.
}
\usage{
microbiome
}
\description{
The \code{microbiome} data contains paired DNA samples from before treatment and 21 months after treatment for helminth infections \insertCite{martin2019mi}{scorematchingad}.
This data was analysed by \insertCite{martin2019mi;textual}{scorematchingad} and a further subset was studied by \insertCite{scealy2023sc;textual}{scorematchingad}.
The data are from a study into the effect of helminth infections on the course of malaria infections (ImmunoSPIN-Malaria) in the Nangapanda subdistrict, Indonesia \insertCite{wiria2010do}{scorematchingad}.
As part of the study, some participants were given 400mg of albendazole every three months for 1.5 years,
remaining participants were given a placebo
\insertCite{wiria2010do}{scorematchingad}.
}
\details{
The measurements in the data come from stool samples before and after treatment.
Gut microbiome prevalence was measured using 16s rRNA 454 sequencing \insertCite{martin2019mi}{scorematchingad}.
Helminth infections were detected by PCR or microscopy \insertCite{martin2019mi}{scorematchingad}.

The subset studied by  \insertCite{scealy2023sc;textual}{scorematchingad} contained only the measurements from before treatment, and only those individuals with a helminth infection.
These measurements can be obtained by running

\if{html}{\out{<div class="sourceCode">}}\preformatted{microbiome[(microbiome$Year == 2008) & microbiome$Helminth, ]
}\if{html}{\out{</div>}}

Two further individuals (\code{IndividualID} of \code{2079} and \code{2280}) were deemed outliers by \insertCite{scealy2023sc;textual}{scorematchingad}.
}
\section{Modifications from the Source}{
The \code{microbiome} data was created from the file \code{S1_Table.xlsx} hosted on \href{http://nematode.net/Data/environmental_interaction/S1_Table.xlsx}{Nematode.net} using the below code.

\if{html}{\out{<div class="sourceCode">}}\preformatted{microbiome <- readxl::read_excel("S1_Table.xlsx",
  range = "A3:AE303") #avoids the genus data, keeping - only phyla
metacolnames <- readxl::read_excel("S1_Table.xlsx",
  range = "A2:J2", 
  col_names = FALSE)
colnames(microbiome)[1:ncol(metacolnames)] <- metacolnames[1, ]
colnames(microbiome)[2] <- "Year"
microbiome[, 11] <- (microbiome$ct_Al <= 30) | (microbiome$ct_Na <= 30) |
  (microbiome$ct_Ad <= 30) | (microbiome$ct_St <= 30) |
  (microbiome$micr_Tt == 1)
colnames(microbiome)[11] <- "Helminth"
microbiome <- microbiome |>
  dplyr::mutate(across(c(1,2,3,12:31), as.integer)) |>
  dplyr::mutate(micr_Tt = as.logical(micr_Tt),
                Treatment = as.logical(Treatment)) |>
  dplyr::rename(IndividualID = `Individual ID`)
microbiome <- as.data.frame(microbiome)
}\if{html}{\out{</div>}}
}

\references{
\insertAllCited{}
}
\keyword{datasets}
