% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppi_paramvec.R, R/ppi_utils.R, R/ppi_toAStar.R
\name{ppi_param_tools}
\alias{ppi_param_tools}
\alias{ppi_paramvec}
\alias{ppi_parammats}
\alias{ppi_toAstar}
\alias{ppi_fromAstar}
\title{PPI Parameter Tools}
\usage{
ppi_paramvec(
  p = NULL,
  AL = NULL,
  bL = NULL,
  Astar = NULL,
  beta = NULL,
  betaL = NULL,
  betap = NULL
)

ppi_parammats(paramvec)

ppi_toAstar(AL, bL)

ppi_fromAstar(Astar)
}
\arguments{
\item{p}{The number of components. If \code{NULL} then \code{p} will be inferred from other inputs.}

\item{AL}{Either \code{NULL}, a p-1 x p-1 symmetric matrix, a number, or "diag".
If NULL then all \eqn{A_L} elements will be set to NA.
If a single number, then \eqn{A_L} will be fixed as a matrix of the given value.
If "diag" then the non-diagonal elements of \eqn{A_L} will be fixed to 0, and the diagonal will be \code{NA}.}

\item{bL}{Either \code{NULL}, a number, or a vector of length p-1.
If \code{NULL}, then all elements of \eqn{b_L} will be set to \code{NA}.
If a single number, then \eqn{b_L} will be fixed at the supplied value.}

\item{Astar}{The \eqn{A^*} matrix (a p by p symmetric matrix)}

\item{beta}{Either \code{NULL}, a number, or a vector of length p.
If NULL then all elements of \eqn{\beta} will be set to \code{NA}.
If a single number then the \eqn{\beta} elements will be fixed at the given number.}

\item{betaL}{Either \code{NULL}, a number, or a vector of length p-1.
If \code{NULL} then the 1...(p-1)th \eqn{\beta} elements will be set to \code{NA}.
If a single number then the 1...(p-1)th \eqn{\beta} elements will be fixed at the given number.}

\item{betap}{Either \code{NULL} or a number.
If \code{NULL} then the \code{p}th element of \eqn{\beta} will be set to \code{NA}, and \code{\link[=ppi]{ppi()}} will estimate it.
If a number, then the pth element of \eqn{\beta} will be fixed at the given value.}

\item{paramvec}{A PPI parameter vector, typically created by \code{\link[=ppi_paramvec]{ppi_paramvec()}} or as an output of \code{\link[=ppi]{ppi()}}.}
}
\value{
\code{ppi_paramvec()}: a vector of length \eqn{p + (p-1)(2 + (p-1)/2)}.

\code{ppi_parammats()}: A named list of \eqn{A_L}, \eqn{b_L}, and \eqn{\beta}.

\code{ppi_toAstar()}: The matrix \eqn{A^*}.

\code{ppi_fromAstar()}: A list of the matrix \eqn{A_L}, the vector \eqn{b_L} and a discarded constant.
}
\description{
The default parameterisation of the PPI model is a symmetric covariance-like matrix \eqn{A_L}, a location-like vector \eqn{b_L} and a set of Dirichlet exponents \eqn{\beta}. For \code{p} components, \eqn{A_L} has \code{p-1} rows, \eqn{b_L} is a vector with \code{p-1} elements and \eqn{\beta} is a vector with \code{p} elements.
For score matching estimation this form of the parameters must be converted into a single parameter vector using \code{ppi_paramvec()}.
\code{ppi_paramvec()} also includes easy methods to set parameters to \code{NA} for estimation with \code{\link[=ppi]{ppi()}} (in \code{\link[=ppi]{ppi()}} the NA-valued elements are estimated and all other elements are fixed).
The reverse of \code{ppi_paramvec()} is \code{ppi_parammats()}.
An alternative parametrisation of the PPI model uses a single \code{p} by \code{p}  matrix \eqn{A^*} instead of \eqn{A_L} and \eqn{b_L}, and for identifiability \eqn{A^*} is such that \eqn{1^T A^* 1 = 0} where \eqn{1=(1,1,...,1)} and \eqn{0=(0,0,..., 0)} \insertCite{scealy2023sc}{scorematchingad}.
Convert between parametrisations using \code{ppi_toAstar()} and \code{ppi_fromAstar()}.
}
\details{
\code{ppi_paramvec()} returns a vector starting with the diagonal elements of \eqn{A_L}, then the off-diagonal elements extracted by \code{\link[=upper.tri]{upper.tri()}} (which extracts elements of \eqn{A_L} along each row, left to right, then top to bottom), then \eqn{b_L}, then \eqn{\beta}.

The \code{Astar} parametrisation rewrites the PPI density as proportional to
\deqn{\exp(z^TA^*z)\prod_{i=1}^p z_i^{\beta_i},}
where \eqn{A^*} (\code{Astar}) is a \eqn{p} by \eqn{p} matrix.
Because \eqn{z} lies in the simplex (in particular \eqn{\sum z_i = 1}), the density is the same regardless of the value of \eqn{1^T A^* 1}=\code{sum(Astar)}, where \eqn{1} is the vector of ones. Thus \eqn{A_L} and \eqn{b_L} specify \eqn{A^*} up to an additive factor. In the conversion \code{ppi_toAstar()}, \eqn{A^*} is returned such that \eqn{1^T A^* 1 = 0}.
\code{NULL} values or \code{NA} elements are not allowed for \code{ppi_toAstar()} and \code{ppi_fromAstar()}.
}
\section{PPI Model}{

The PPI model density is proportional to
\deqn{\exp(z_L^TA_Lz_L + b_L^Tz_L)\prod_{i=1}^p z_i^{\beta_i},}
where \eqn{p} is the dimension of a compositional measurement \eqn{z}, and \eqn{z_L} is \eqn{z} without the final (\eqn{p}th) component.
\eqn{A_L} is a \eqn{p-1 \times p-1} symmetric matrix that controls the covariance between components.
\eqn{b_L} is a \eqn{p-1} vector that controls the location within the simplex.
The \eqn{i}th component \eqn{\beta_i} of \eqn{\beta} controls the concentration of density when \eqn{z_i} is close to zero: when \eqn{\beta_i \geq 0} there is no concentration and \eqn{\beta_i} is hard to identify; when \eqn{\beta_i < 0} then the probability density of the PPI model increases unboundedly as \eqn{z_i} approaches zero, with the increasing occuring more rapidly and sharply the closer \eqn{\beta_i} is to \eqn{-1}.
}

\examples{
ppi_paramvec(AL = "diag", bL = 0, betap = -0.5, p = 3)
vec <- ppi_paramvec(AL = rsymmetricmatrix(2), beta = c(-0.8, -0.7, 0))
ppi_parammats(vec)
Astar <- rWishart(1, 6, diag(3))[,,1]
ppi_fromAstar(Astar)
ppi_toAstar(ppi_fromAstar(Astar)$AL, ppi_fromAstar(Astar)$bL)
}
\seealso{
Other PPI model tools: 
\code{\link{dppi}()},
\code{\link{ppi_robust}()},
\code{\link{ppi}()},
\code{\link{rppi}()}
}
\concept{PPI model tools}
