% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise-comparisons.R
\name{pairwise_comparison_one_group}
\alias{pairwise_comparison_one_group}
\title{Do Pairwise Comparison for one Set of Forecasts}
\usage{
pairwise_comparison_one_group(scores, metric, baseline, by, ...)
}
\arguments{
\item{scores}{A data.table of scores as produced by \code{\link[=score]{score()}}.}

\item{metric}{A character vector of length one with the metric to do the
comparison on. The default is "auto", meaning that either "interval_score",
"crps", or "brier_score" will be selected where available.
See \code{\link[=available_metrics]{available_metrics()}} for available metrics.}

\item{baseline}{character vector of length one that denotes the baseline
model against which to compare other models.}

\item{by}{character vector with names of columns present in the input
data.frame. \code{by} determines how pairwise comparisons will be computed.
You will get a relative skill score for every grouping level determined in
\code{by}. If, for example, \code{by = c("model", "location")}. Then you will get a
separate relative skill score for every model in every location. Internally,
the data.frame will be split according \code{by} (but removing "model" before
splitting) and the pairwise comparisons will be computed separately for the
split data.frames.}

\item{...}{additional arguments for the comparison between two models. See
\code{\link[=compare_two_models]{compare_two_models()}} for more information.}
}
\description{
This function does the pairwise comparison for one set of forecasts, but
multiple models involved. It gets called from \code{\link[=pairwise_comparison]{pairwise_comparison()}}.
\code{\link[=pairwise_comparison]{pairwise_comparison()}} splits the data into arbitrary subgroups specified
by the user (e.g. if pairwise comparison should be done separately for
different forecast targets) and then the actual pairwise comparison for that
subgroup is managed from \code{\link[=pairwise_comparison_one_group]{pairwise_comparison_one_group()}}. In order to
actually do the comparison between two models over a subset of common
forecasts it calls \code{\link[=compare_two_models]{compare_two_models()}}.
}
\keyword{internal}
