% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-forecast-binary.R,
%   R/class-forecast-point.R, R/class-forecast-quantile.R,
%   R/class-forecast-sample.R, R/class-forecast.R
\name{assert_forecast.forecast_binary}
\alias{assert_forecast.forecast_binary}
\alias{assert_forecast.forecast_point}
\alias{assert_forecast.forecast_quantile}
\alias{assert_forecast.forecast_sample}
\alias{assert_forecast}
\alias{assert_forecast.default}
\title{Assert that input is a forecast object and passes validations}
\usage{
\method{assert_forecast}{forecast_binary}(forecast, forecast_type = NULL, verbose = TRUE, ...)

\method{assert_forecast}{forecast_point}(forecast, forecast_type = NULL, verbose = TRUE, ...)

\method{assert_forecast}{forecast_quantile}(forecast, forecast_type = NULL, verbose = TRUE, ...)

\method{assert_forecast}{forecast_sample}(forecast, forecast_type = NULL, verbose = TRUE, ...)

assert_forecast(forecast, forecast_type = NULL, verbose = TRUE, ...)

\method{assert_forecast}{default}(forecast, forecast_type = NULL, verbose = TRUE, ...)
}
\arguments{
\item{forecast}{A forecast object (a validated data.table with predicted and
observed values).}

\item{forecast_type}{(optional) The forecast type you expect the forecasts
to have. If the forecast type as determined by \code{scoringutils} based on the
input does not match this, an error will be thrown. If \code{NULL} (the
default), the forecast type will be inferred from the data.}

\item{verbose}{Logical. If \code{FALSE} (default is \code{TRUE}), no messages and
warnings will be created.}

\item{...}{Currently unused. You \emph{cannot} pass additional arguments to scoring
functions via \code{...}. See the \emph{Customising metrics} section below for
details on how to use \code{\link[purrr:partial]{purrr::partial()}} to pass arguments to individual
metrics.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
Assert that an object is a forecast object (i.e. a \code{data.table} with a class
\code{forecast} and an additional class \verb{forecast_<type>} corresponding to the
forecast type).

See the corresponding \verb{assert_forecast_<type>} functions for more details on
the required input formats.
}
\examples{
forecast <- as_forecast_binary(example_binary)
assert_forecast(forecast)
}
\keyword{validate-forecast-object}
