% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-interval-range.R
\name{assert_input_interval}
\alias{assert_input_interval}
\title{Assert that inputs are correct for interval-based forecast}
\usage{
assert_input_interval(observed, lower, upper, interval_range)
}
\arguments{
\item{observed}{Input to be checked. Should be a numeric vector with the
observed values of size n.}

\item{lower}{Input to be checked. Should be a numeric vector of size n that
holds the predicted value for the lower bounds of the prediction intervals.}

\item{upper}{Input to be checked. Should be a numeric vector of size n that
holds the predicted value for the upper bounds of the prediction intervals.}

\item{interval_range}{Input to be checked. Should be a vector of size n that
denotes the interval range in percent. E.g. a value of 50 denotes a
(25\%, 75\%) prediction interval.}
}
\value{
Returns NULL invisibly if the assertion was successful and throws an
error otherwise.
}
\description{
Function assesses whether the inputs correspond to the
requirements for scoring interval-based forecasts.
}
\keyword{internal_input_check}
