% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-quantile.R
\name{assert_input_quantile}
\alias{assert_input_quantile}
\title{Assert that inputs are correct for quantile-based forecast}
\usage{
assert_input_quantile(
  observed,
  predicted,
  quantile_level,
  unique_quantile_levels = TRUE
)
}
\arguments{
\item{observed}{Input to be checked. Should be a numeric vector with the
observed values of size n.}

\item{predicted}{Input to be checked. Should be nxN matrix of predictive
quantiles, n (number of rows) being the number of data points and N
(number of columns) the number of quantiles per forecast.
If \code{observed} is just a single number, then predicted can just be a
vector of size N.}

\item{quantile_level}{Input to be checked. Should be a vector of size N that
denotes the quantile levels corresponding to the columns of the prediction
matrix.}

\item{unique_quantile_levels}{Whether the quantile levels are required to be
unique (\code{TRUE}, the default) or not (\code{FALSE}).}
}
\value{
Returns NULL invisibly if the assertion was successful and throws an
error otherwise.
}
\description{
Function assesses whether the inputs correspond to the
requirements for scoring quantile-based forecasts.
}
\keyword{internal_input_check}
