% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics-sample.R
\name{bias_sample}
\alias{bias_sample}
\title{Determine bias of forecasts}
\usage{
bias_sample(observed, predicted)
}
\arguments{
\item{observed}{A vector with observed values of size n}

\item{predicted}{nxN matrix of predictive samples, n (number of rows) being
the number of data points and N (number of columns) the number of Monte
Carlo samples. Alternatively, \code{predicted} can just be a vector of size n.}
}
\value{
Numeric vector of length n with the biases of the predictive samples with
respect to the observed values.
}
\description{
Determines bias from predictive Monte-Carlo samples. The function
automatically recognises whether forecasts are continuous or
integer valued and adapts the Bias function accordingly.
}
\details{
For continuous forecasts, Bias is measured as

\deqn{
B_t (P_t, x_t) = 1 - 2 * (P_t (x_t))
}

where \eqn{P_t} is the empirical cumulative distribution function of the
prediction for the observed value \eqn{x_t}. Computationally, \eqn{P_t (x_t)} is
just calculated as the fraction of predictive samples for \eqn{x_t}
that are smaller than \eqn{x_t}.

For integer valued forecasts, Bias is measured as

\deqn{
B_t (P_t, x_t) = 1 - (P_t (x_t) + P_t (x_t + 1))
}

to adjust for the integer nature of the forecasts.

In both cases, Bias can assume values between
-1 and 1 and is 0 ideally.
}
\section{Input format}{
\if{html}{
  \out{<div style="text-align: left">}
  \figure{metrics-sample.png}{options: style="width:750px;max-width:100\%;"}
  \out{</div><p>}
  Overview of required input format for sample-based forecasts
}
\if{latex}{
  \figure{metrics-sample.png}
}
}

\examples{

## integer valued forecasts
observed <- rpois(30, lambda = 1:30)
predicted <- replicate(200, rpois(n = 30, lambda = 1:30))
bias_sample(observed, predicted)

## continuous forecasts
observed <- rnorm(30, mean = 1:30)
predicted <- replicate(200, rnorm(30, mean = 1:30))
bias_sample(observed, predicted)
}
\references{
The integer valued Bias function is discussed in
Assessing the performance of real-time epidemic forecasts: A case study of
Ebola in the Western Area region of Sierra Leone, 2014-15 Funk S, Camacho A,
Kucharski AJ, Lowe R, Eggo RM, et al. (2019) Assessing the performance of
real-time epidemic forecasts: A case study of Ebola in the Western Area
region of Sierra Leone, 2014-15. PLOS Computational Biology 15(2): e1006785.
\doi{10.1371/journal.pcbi.1006785}
}
\keyword{metric}
