% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperpar_mod.r
\name{hyperpar_mod}
\alias{hyperpar_mod}
\title{Find Scale Parameter for modular regression}
\usage{
hyperpar_mod(Z, K1, K2, A, c = 0.1, alpha = 0.1, omegaseq, omegaprob,
  R = 10000, myseed = 123, thetaseq = NULL, type = "IG",
  lowrank = FALSE, k = 5, mc = FALSE, ncores = 1, truncate = 1)
}
\arguments{
\item{Z}{rows from the tensor product design matrix}

\item{K1}{precision matrix1}

\item{K2}{precision matrix2}

\item{A}{constraint matrix}

\item{c}{threshold from eq. (8) in Klein & Kneib (2016)}

\item{alpha}{probability parameter from eq. (8) in Klein & Kneib (2016)}

\item{omegaseq}{sequence of weights for the anisotropy}

\item{omegaprob}{prior probabilities for the weights}

\item{R}{number of simulations}

\item{myseed}{seed in case of simulation. default is 123.}

\item{thetaseq}{possible sequence of thetas. default is NULL.}

\item{type}{type of hyperprior for tau/tau^2; options: IG => IG(1,theta) for tau^2, SD => WE(0.5,theta) for tau^2, HN => HN(0,theta) for tau, U => U(0,theta) for tau, HC => HC(0,theta) for tau}

\item{lowrank}{default is FALSE. If TRUE a low rank approximation is used for Z with k columns.}

\item{k}{only used if lowrank=TRUE. specifies target rank of low rank approximation. Default is 5.}

\item{mc}{default is FALSE. only works im thetaseq is supplied. can parallel across thetaseq.}

\item{ncores}{default is 1. number of cores is mc=TRUE}

\item{truncate}{default is 1. If < 1 the lowrank approximation is based on on cumsum(values)/sum(values).}
}
\value{
the optimal value for theta
}
\description{
Find Scale Parameter for modular regression
}
\references{
Kneib, T., Klein, N., Lang, S. and Umlauf, N. (2017) Modular Regression - A Lego System for Building Structured Additive Distributional Regression Models with Tensor Product Interactions 
\emph{Working Paper}.
}
\author{
Nadja Klein, Thomas Kneib
}
