% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdf_ig.r
\name{mdf_ig}
\alias{mdf_ig}
\title{Marginal Density for Given Scale Parameter and Inverse Gamma Prior for \eqn{\tau^2}}
\usage{
mdf_ig(f, theta, Z, Kinv)
}
\arguments{
\item{f}{point the marginal density to be evaluated at.}

\item{theta}{denotes the scale parameter of the inverse gamma hyperprior.}

\item{Z}{the row of the design matrix evaluated.}

\item{Kinv}{the generalised inverse of K.}
}
\value{
the marginal density evaluated at point x.
}
\description{
This function computes the marginal density of \eqn{z_p'\beta} for inverse gamma
hyperpriors with shape parameter a=1.
}
\examples{
set.seed(123)
library(MASS)
# prior precision matrix (second order differences) 
# of a spline of degree l=3 and with m=20 inner knots
# yielding dim(K)=m+l-1=22
K <- t(diff(diag(22), differences=2))\%*\%diff(diag(22), differences=2)
# generalised inverse of K
Kinv <- ginv(K)
# covariate x
x <- runif(1)
Z <- matrix(DesignM(x)$Z_B,nrow=1)
fgrid <- seq(-3,3,length=1000)
mdf <- mdf_ig(fgrid,theta=0.0028,Z=Z,Kinv=Kinv)

}
\references{
Nadja Klein and Thomas Kneib (2015). Scale-Dependent Priors for Variance Parameters in Structured Additive Distributional Regression. 
\emph{Working Paper}.
}
\author{
Nadja Klein
}
