% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{sdcTargetMatrixClass-class}
\alias{initialize,sdcTargetMatrixClass-method}
\alias{sdcTargetMatrixClass-class}
\title{S4 Target Matrix}
\usage{
\S4method{initialize}{sdcTargetMatrixClass}(.Object, ...)
}
\arguments{
\item{.Object}{An \code{\linkS4class{sdcTargetMatrixClass}} object.}

\item{...}{The optional parameters specifying the basis of the
target matrix (Tdef).}
}
\description{
The taget matrix is a matrix with the same dimensions as the
  data from which it is derived, that indicates the number of
  combinations at a specific level of targetting for which the
  synthesis of a data element will make the record "sufficiently
  common".
}
\details{
Additional information is stored in the slots.
}
\section{Methods (by generic)}{
\itemize{
\item \code{initialize}: 
}}
\section{Slots}{

\describe{
\item{\code{.Data}}{A matrix.}

\item{\code{Tdef}}{A target definition class object.}
}}
\examples{
set.seed(256)
my.X <- data.frame(matrix(ifelse(runif(500)>.5, TRUE, FALSE), ncol = 5))
my.tdef <- new("sdcTargetDefinitionClass", X = my.X)
new("sdcTargetMatrixClass", Tdef = my.tdef)
}
\seealso{
\code{\linkS4class{sdcTargetDefinitionClass}},
}

