% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{euler2D}
\alias{euler2D}
\title{Simulation of trajectories of the WN or MvM diffusion in 2D}
\usage{
euler2D(x0, A, mu, sigma, rho = 0, N = 100L, delta = 0.01, type = 1L,
  maxK = 2L, expTrc = 30)
}
\arguments{
\item{x0}{matrix of size \code{c(nx0, 2)} giving the initial points.}

\item{A}{drift matrix of size \code{c(2, 2)}.}

\item{mu}{a vector of length \code{2} giving the mean.}

\item{sigma}{vector of length \code{2} containing the \strong{square root} of the diagonal of \eqn{\Sigma}, the diffusion matrix.}

\item{rho}{correlation coefficient of \eqn{\Sigma}.}

\item{N}{number of discretization steps.}

\item{delta}{discretization step.}

\item{type}{integer giving the type of diffusion. Currently, only \code{1} for WN and \code{2} for vM are supported.}

\item{maxK}{maximum absolute value of the windings considered in the computation of the WN.}

\item{expTrc}{truncation for exponential: \code{exp(x)} with \code{x <= -expTrc} is set to zero. Defaults to \code{30}.}
}
\value{
An array of size \code{c(nx0, 2, N + 1)} containing the \code{nx0} discretized trajectories. The first slice corresponds to the matrix \code{x0}.
}
\description{
Simulation of the Wrapped Normal (WN) diffusion or Multivariate von Mises (MvM) diffusion by the Euler method in 2D, for several starting values.
}
\examples{
N <- 100
nx0 <- 5
x0 <- seq(-pi, pi, l = nx0 + 1)[-(nx0 + 1)]
x0 <- as.matrix(expand.grid(x0, x0))
nx0 <- nx0^2
set.seed(12345678)
samp <- euler2D(x0 = x0, mu = c(0, 0), A = rbind(c(3, 1), 1:2),
                sigma = c(1, 1), N = N, delta = 0.01, type = 2)
plot(x0[, 1], x0[, 2], xlim = c(-pi, pi), ylim = c(-pi, pi), pch = 16,
     col = rainbow(nx0))
for (i in 1:nx0) linesTorus(samp[i, 1, ], samp[i, 2, ],
                           col = rainbow(nx0, alpha = 0.5)[i])
}
